;*************************************************************************
;
;         PIC 18F2550 - ARBGEN .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 03.10.2008
;  Status    : A2.00                Known Bugs : non
;  Fuses     : See Source
;
;  Arbitrer Frequenz-Generator fr Frequenzen im Bereich 2Hz bis 4kHz.
;  Durch Angabe von bis zu 64 Sttzstellen knnen 2 Kurvenformen unabhngig
;  voneinander definiert werden. Dieses Frequenz-ber-Zeit Profil wird dann
;  abgefahren und auf 2 Kanlen ausgegeben. Bei Frequenzen <2Hz wird der 
;  Ausgang komplett abgeschaltet. Whrend der Ausfhrung der Waveform
;  blinkt die Status-LED.
;  
;  Per BCD-Codier-Schalter sind bis zu 16 verschiedene Frequenzverlufe whlbar, 
;  per Schalter kann zwischen Single oder Repetitive gewhlt werden. 
;  Trigger ist mglich per separatem Eingang oder einem Taster.
;  
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 02 |      | Channel 1 Ausgang
; | Port A RA1 Pin 03 |      | Channel 2 Ausgang
; | Port A RA2 Pin 04 |      | Status LED Ausgang
; | Port A RA3 Pin 05 |      | -
; | Port A RA4 Pin 06 |      | - (OC Ausgang)
; | Port A RA5 Pin 07 |      | -
; |
; | Port B RB0 Pin 21 |      | Table-Selection DIP-Switch4 LSB
; | Port B RB1 Pin 22 |      | Table-Selection DIP-Switch3
; | Port B RB2 Pin 23 |      | Table-Selection DIP-Switch2
; | Port B RB3 Pin 24 |      | Table-Selection DIP-Switch1 MSB
; | Port B RB4 Pin 25 |      | Single/Repetitive Schalter
; | Port B RB5 Pin 26 |      | Trigger
; | Port B RB6 Pin 27 |      | -
; | Port B RB7 Pin 28 |      | -
; |
; | Port C RC0 Pin 11 |      | - (OC Ausgang)
; | Port C RC1 Pin 12 |      | - (OC Ausgang)
; | Port C RC2 Pin 13 |      | - (OC Ausgang)
; | Port C RC3 Pin 14 |      | Spannungsregler USB 3V 
; | Port C RC4 Pin 15 |      | -
; | Port C RC5 Pin 16 |      | -
; | Port C RC6 Pin 17 |  TX  | TX RS232 115200 Baud
; | Port C RC7 Pin 18 |  RX  | RX RS232 115200 Baud
;
; Oszillator :  20 Mhz Osc, dann interne PLL auf 48 MHz, damit
; interner Taktzyklus 12 MHz -> 83,333ns pro Instruction Cycle
;
; max. STACK-LEVEL liegt 31 auf dem 18F2550
;
;*************************************************************************

	LIST P=18F2550, F=INHX32	; Prozessor definieren
	#include <P18F2550.INC>		; Variablen fr den Prozessor definieren

	; Achtung : Die folgenden Einstellungen werden bei Einprogrammieren des Boot-Loaders gemacht
	; sptere ndungen wie unten per Source-Code sind beim Bootloader nicht mglich.
	
	CONFIG PLLDIV = 5 ; 96 MHz PLL Prescaler:  (20 MHz input)
	CONFIG CPUDIV = OSC1_PLL2 ; System Clock Postscaler: [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]
	CONFIG USBDIV = 2 ; Full-Speed USB Clock Source: 96 MHz PLL/2 ;
	CONFIG FOSC = HS ; HS oscillator, HS used by USB
	CONFIG FCMEN = ON ; Fail-Safe Clock Monitor enabled   
	CONFIG IESO = OFF ; Internal/External Switch Over Disabled
	CONFIG PWRT = ON ; Power-up Timer enabled
	CONFIG BOR = ON_ACTIVE ; Brown-out Reset Enabled when the device is not
	CONFIG BORV = 3 ; 
	CONFIG VREGEN = ON ; USB Voltage Regulator Enabled
	CONFIG WDT = ON ; Watchdog timer = HW Enabled - SW Disabled
	CONFIG WDTPS = 128 ; Watchdog Postscaler = 1:128
	CONFIG MCLRE = ON ; MCLR Enabled
	CONFIG LPT1OSC = OFF ; Timer1 oscillator configured for high power
	CONFIG PBADEN = OFF ; PORTB<4:0> pins are configured as digital I/O on Reset
	CONFIG CCP2MX = OFF ; CCP2 input/output is multiplexed with RB3
	CONFIG STVREN = OFF ; Stack Overflow Reset Disabled
	CONFIG LVP = OFF ; Low Voltage Programming Disabled
	CONFIG XINST = OFF ; Extended Instruction Set Disabled
	CONFIG DEBUG = OFF ; Background Debugger Disabled
	CONFIG CP0 = OFF ; Code Protection Block 0 Disabled
        CONFIG CP1 = OFF ; Code Protection Block 1 Disabled
        CONFIG CP2 = OFF ; Code Protection Block 2 Disabled
        CONFIG CP3 = OFF ; Code Protection Block 3 Disabled
        CONFIG CPB = OFF ; Boot Block Code Protection Disabled
        CONFIG CPD = OFF ; Data EEPROM Code Protection Disabled
        CONFIG WRT0 = OFF ; Write Protection Block 0 Disabled
        CONFIG WRT1 = OFF ; Write Protection Block 1 Disabled
        CONFIG WRT2 = OFF ; Write Protection Block 2 Disabled
        CONFIG WRT3 = OFF ; Write Protection Block 3 Disabled
        CONFIG WRTB = OFF ; Boot Block Write Protection Disabled
        CONFIG WRTC = OFF ; Configuration Register Write Protection Disabled
        CONFIG WRTD = OFF ; Data EEPROM Write Protection Disabled
        CONFIG EBTR0 = OFF ; Table Read Protection Block 0 Disabled
        CONFIG EBTR1 = OFF ; Table Read Protection Block 1 Disabled
        CONFIG EBTR2 = OFF ; Table Read Protection Block 2 Disabled
        CONFIG EBTR3 = OFF ; Table Read Protection Block 3 Disabled
        CONFIG EBTRB = OFF ; Boot Block Table Read Protection Disabled

#define	CARRY		0x00
#define ZERO		0x02	

T01		RES 1 ; Zwischen-Speicher
T02		RES 1 ; Zwischen-Speicher
T03     	RES 1 ; Zwischen-Speicher
T04		RES 1 ;	Zwischen-Speicher
T05		RES 1 ; Zwischen-Speicher
T06		RES 1 ; Zwischen-Speicher
PROGST		RES 1 ; Programm-Status
PROGST2		RES 1 ; Programm-Status
WREG_TEMP	RES 1 ; fr ISR-Routine
STATUS_TEMP	RES 1 ; fr ISR-Routine
BSR_TEMP	RES 1 ; fr ISR-Routine
WREG_TEMP2	RES 1 ; fr ISR-Routine
STATUS_TEMP2	RES 1 ; fr ISR-Routine
BSR_TEMP2	RES 1 ; fr ISR-Routine
NUMH		RES 1 ;	Speicher
NUML		RES 1 ;	Speicher
TENK		RES 1 ;	Speicher
THOU		RES 1 ;	Speicher
HUND		RES 1 ;	Speicher
TENS		RES 1 ;	Speicher
ONES		RES 1 ;	Speicher
ACC1L		RES 1 ;	Speicher
ACC1H		RES 1 ;	Speicher
ACC2L		RES 1 ;	Speicher
ACC2H		RES 1 ;	Speicher
P1XL		RES 1 ;	Speicher
P1XH		RES 1 ;	Speicher
P1YL		RES 1 ;	Speicher
P1YH		RES 1 ;	Speicher
P2XL		RES 1 ;	Speicher
P2XH		RES 1 ;	Speicher
P2YL		RES 1 ;	Speicher
P2YH		RES 1 ;	Speicher
DELXL		RES 1 ;	Speicher
DELXH		RES 1 ;	Speicher
DELYL		RES 1 ;	Speicher
DELYH		RES 1 ;	Speicher
SLOSTAT		RES 1 ;	Speicher
TEMAL		RES 1 ;	Speicher
TEMAH		RES 1 ;	Speicher
TEMBL		RES 1 ;	Speicher
TEMBH 		RES 1 ;	Speicher
TEMEL		RES 1 ;	Speicher
TEMEH		RES 1 ;	Speicher
CORRH		RES 1 ;	Speicher
CORRL		RES 1 ; Speicher
TABCNT		RES 1 ; Speicher
P1XLB		RES 1 ;	Speicher
P1XHB		RES 1 ;	Speicher
P1YLB		RES 1 ;	Speicher
P1YHB		RES 1 ;	Speicher
P2XLB		RES 1 ;	Speicher
P2XHB		RES 1 ;	Speicher
P2YLB		RES 1 ; Speicher
P2YHB		RES 1 ; Speicher
DELXLB		RES 1 ; Speicher
DELXHB		RES 1 ;	Speicher
DELYLB		RES 1 ;	Speicher
DELYHB		RES 1 ;	Speicher
SLOSTATB	RES 1 ; Speicher
TEMALB		RES 1 ;	Speicher
TEMAHB		RES 1 ;	Speicher
TEMBLB		RES 1 ;	Speicher
TEMBHB		RES 1 ;	Speicher
TEMELB		RES 1 ;	Speicher
TEMEHB		RES 1 ;	Speicher
CORRHB		RES 1 ;	Speicher
CORRLB		RES 1 ;	Speicher
TABCNTB		RES 1 ;	Speicher
REZIPL		RES 1 ;	Speicher
REZIPH		RES 1 ;	Speicher
ACC3L		RES 1 ;	Speicher
ACC3H		RES 1 ;	Speicher
CH1CNT		RES 1 ; Speicher
CH2CNT		RES 1 ; Speicher
CH1ACTH		RES 1 ; Speicher
CH1ACTL		RES 1 ; Speicher
CH1NEWH		RES 1 ; Speicher
CH1NEWL		RES 1 ; Speicher
CH2ACTH		RES 1 ; Speicher
CH2ACTL		RES 1 ; Speicher
CH2NEWH		RES 1 ; Speicher
CH2NEWL		RES 1 ; Speicher
DIPSW		RES 1 ; Speicher

;
; PROGST-Variable
;
; 76543210
; 7654 : 4 Bit DIP-Schalter, welche Kurvenform
; 3 : Schalter ob Kurvenform wiederholend oder einmal abgefahren wird
; 2 : Neuer Wert fr CH2 vorhanden, bitte abholen
; 1 : Neuer Wert fr CH1 vorhanden, bitte abholen
; 0 : Berechnungsroutine 0:CHA ist dran, 1:CHB ist dran
;
; PROGST2-Variable
;
; 76543210
; 7 : -
; 6 : CH2 : High = Frequenz <2Hz, Kanal 2 ausschalten
; 5 : CH1 : High = Frequenz <2Hz, Kanal 2 ausschalten
; 4 : CH2 : High = Frequenz <20Hz, also 10mal ausfhren, Zur Zeit gltiger Wert
; 3 : CH1 : High = Frequenz <20Hz, also 10mal ausfhren, Zur Zeit gltiger Wert
; 2 : CH2 : High = Frequenz <20Hz, also 10mal ausfhren, Merker nach der Berechnung 
; 1 : CH1 : High = Frequenz <20Hz, also 10mal ausfhren, Merker nach der Berechnung
; 0 : -

	
;*************************************************************************
; Anweisung fr Bootloader - nicht ndern
;*************************************************************************

	ORG     0x0000		; Speicherstelle 0
	goto    INIT		; Zum Programmstart

;*************************************************************************
; Anweisung fr Interrupt Service Routine
;*************************************************************************
	
	ORG 	0x008		; Speicherstelle 08
	goto 	HIGHINT		; Interrupt-Vektor High Priority

	ORG 	0x018		; Speicherstelle 18
	goto 	LOWINT		; Interrupt-Vektor Low Priority
		
;*************************************************************************
; INIT - Erster Programmstart
;*************************************************************************
		
INIT	bcf	ADCON0,ADON	; A/D Wandler abschalten
	
	; TRIS-Register : 0=Ausgang, 1=Eingang
	
	movlw 	B'11111000'     ; RA0..RA2 Ausgnge, Rest Eingang
 	movwf   TRISA		;

	movlw	B'11111111'	; Alles Eingnge	
 	movwf   TRISB		;
 	
 	movlw 	B'11111111'     ; Alles Eingnge (TX wird spter gendert)
 	movwf   TRISC		;
 	
 	movlw 	B'00000000'	; SPI Mode
	movwf 	SSPSTAT 	; time sampling

 	BSF	PORTC,6		; TX Leitung auf High

	BSF	RCON,IPEN	; High/Low Priority Level fr Interrupts aktivieren
	
	; Init der Seriellen Schnittstelle fr Debug Mode
	; fr schreiben sowie mit Interrupt fr Lesen

	movlw	0x1A		; Baudrate auf 115200 mit "1A"
	movwf	SPBRG		; Baudrate auf  19200 mit "9C"
	movlw	0x00		;
	movwf	SPBRGH		;
	
	bsf	TXSTA,BRGH	; High-Speed bertragung
	bcf	TXSTA,BRG16	; keine 16 Bit bertragung
	
	bcf	TXSTA,SYNC	; Asynchronen Port enablen
	bsf	RCSTA,SPEN	;
	
	bcf	PIE1,TXIE	; Transmit-Interrupts enablen nicht bentigt
	bsf	TXSTA,TXEN	; Enable Transmission
	
	bcf	PIE1,RCIE	; Receive Interrupt Enable freischalten
 	
 	clrf	PROGST		; Programm-Status Variable lschen
 	clrf	PROGST2		; Programm-Status Variable lschen

	bcf	LATA,2		; Status LED aus

	; Timer 0 initialisieren
	; $F447 => 1ms Task, $8ACF => 10ms Task
	
	movlw	b'00000001'	;
	movwf	T0CON		; Timer 0 hat 16Bit Mode, Internal Clock, Prescaler 1:4
	movlw	0xF4		;
	movwf	TMR0H		;
	movlw	0x47		;
	movwf	TMR0L		; Werte fr 1ms einladen
	bcf	INTCON2,TMR0IP	; TMR0 Interrupt auf Low Priority
	bcf	T0CON,TMR0ON	; Timer 0 enablen   

	; Timer 1 initialisieren
	
	movlw	b'10100000'	; 
	movwf	T1CON		; Timer 1 hat 16Bit Mode, Internal Clock, Prescaler 1:4
	movlw	0x00		;
	movwf	TMR1H		;
	movwf	CH1ACTH		;
	movwf	CH1NEWH		;
	movlw	0x00		;
	movwf	TMR1L		; Testdaten
	movwf	CH1ACTL		;
	movwf	CH1NEWL		;
	movlw	0x1D		;
	movwf	CH1CNT		; Grundwert fr 3mal wiederholen
	bsf	IPR1,TMR1IP	; TMR1 Interrupt auf High Priority
	bsf	T1CON,TMR1ON	; Timer 1 enablen  
	
	; Timer 3 initialisieren
	
	movlw	b'10100000'	;
	movwf	T3CON		; Timer 3 hat 16Bit Mode, Internal Clock, Prescaler 1:4
	movlw	0x00		;
	movwf	TMR3H		;
	movwf	CH2ACTH		;
	movwf	CH2NEWH		;
	movlw	0x00		;
	movwf	TMR3L		; Testdaten
	movwf	CH2ACTL		;
	movwf	CH2NEWL		;
	movlw	0x1D		;
	movwf	CH2CNT		; Grundwert fr 3mal wiederholen
	bsf	IPR2,TMR3IP	; TMR3 Interrupt auf High Priority
	bsf	T3CON,TMR3ON	; Timer 3 enablen			

	; Alle Timer starten
	
	bsf	INTCON,GIEH	; Alle High Priority Interrupts enablen 	
	bsf	INTCON,GIEL	; Alle Low Priority Interrupts disablen
	bsf	INTCON,TMR0IE	; TMR0 Interrupt enablen   			
	bsf	PIE1,TMR1IE	; TMR1 Interrupt enablen  
	bsf	PIE2,TMR3IE	; TMR3 Interrupt enablen   			
 	
	call	TESTA		; Programm starten

STOPO	GOTO	STOPO		; Ab hier lufts nur noch per Interrupt weiter

;*************************************************************************
; TESTA - Neuaufruf, von vorne anfangen
;*************************************************************************

TESTA	bcf	PROGST,0	; CH1

	clrf	TABCNT		; Tabelle von vorne beginnen
	
	call	TABELLE		; lies aus Tabelle
	movwf	P1XH		; nach P1XH
	call	TABELLE		; lies aus Tabelle
	movwf	P1XL		; nach P1XL
	call	TABELLE		; lies aus Tabelle
	movwf	P1YH		; nach P1YH
	call	TABELLE		; lies aus Tabelle
	movwf	P1YL		; nach P1YL
		
	; Frequenz verdoppeln zwecks High/Low-Phase
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P1YH,F		; High Byte links schieben
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P1YL,F		; Low Byte links schieben
	btfsc	STATUS,CARRY	; Ueberlauf ?
	incf	P1YH,F		; eins im High rauf
	
	call	NEWST		;
	call	SWAPAB		; Aktuelles in "B"
	
	bsf	PROGST,0	; CH2

	clrf	TABCNT		; Tabelle von vorne beginnen
	
	call	TABELLE		; lies aus Tabelle
	movwf	P1XH		; nach P1XH
	call	TABELLE		; lies aus Tabelle
	movwf	P1XL		; nach P1XL
	call	TABELLE		; lies aus Tabelle
	movwf	P1YH		; nach P1YH
	call	TABELLE		; lies aus Tabelle
	movwf	P1YL		; nach P1YL
	
	; Frequenz verdoppeln zwecks High/Low-Phase
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P1YH,F		; High Byte links schieben
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P1YL,F		; Low Byte links schieben
	btfsc	STATUS,CARRY	; Ueberlauf ?
	incf	P1YH,F		; eins im High rauf
	
	call	NEWST		;
	call	SWAPAB		; aus "B" wieder zurck
	
	bcf	PROGST,0	; wieder auf CH1 schalten

	; Repetitive oder getriggert ?
	
	btfss	PORTB,4		; Leitung einlesen
	goto	TESTA1		; 0=Repetitive, also gleich weiter machen		

TESTA2	btfss	PORTB,5		; Leitung einlesen
	goto	TESTA1		; Trigger gefunden
	btfss	PORTB,4		; Leitung einlesen
	goto	TESTA1		; 0=Repetitive, also gleich weiter machen
	goto	TESTA2		; nochmal nachschauen
	
TESTA1	bsf	T0CON,TMR0ON	; Timer 0 enablen 	
	return			;
	

;*************************************************************************
; NEWST - ein neuer Sttzpunkt wurde eingelesen
;
; Input		P1XL, P1XH, P1YL, P1YH, P2XL, P2XH, P2YL, P2YH : 2 Sttzpunkte, P1 "aelter", P2 "neuer"
; Output	DELXL, DELXH, DELYL, DELYH : Sttzpunkt-Differenz
;		SLOSTAT : Status-Register der Slope-Detect-Routine
; 			  Y-Schrittrichtung positiv(0:0) oder negativ(0:1)
;			  Steigung kleiner eins (1:0) oder grer eins (1:1)
;		TEMAL, TEMAH, TEMBL, TEMBH, TEMEL, TEMEH : Temporre Speicher fr a,b,e bei Bresenham
;		
;*************************************************************************

NEWST  ; P2 aus der Tabelle holen
	call	TABELLE		; lies aus Tabelle
	movwf	P2XH		; nach P2XH
	call	TABELLE		; lies aus Tabelle
	movwf	P2XL		; nach P2XL
	call	TABELLE		; lies aus Tabelle
	movwf	P2YH		; nach P2YH
	call	TABELLE		; lies aus Tabelle
	movwf	P2YL		; nach P2YL

	; Frequenz verdoppeln zwecks High/Low-Phase
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P2YH,F		; High Byte links schieben
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	P2YL,F		; Low Byte links schieben
	btfsc	STATUS,CARRY	; Ueberlauf ?
	incf	P2YH,F		; eins im High rauf
	
	comf	P2XH,W		; Tabellenende ist $FF $FF
	btfss	STATUS,ZERO	; 0 ?
	goto	NEWST6		; nein, dann normal weiter
	comf	P2XL,W		;
	btfss	STATUS,ZERO	; nein, dann normal weiter
	goto	NEWST6		;
 	call	TESTA		; ganz von vorne anfangen
 	return			;
 	
NEWST6	; Differenz in X-Richtung bilden
	movf	P1XL,W		;
	movwf	ACC2L		;
	movf	P1XH,W		;
	movwf	ACC2H		; P1X in ACC2
	movf	P2XL,W		;
	movwf	ACC1L		;
	movf	P2XH,W		;
	movwf	ACC1H		; P2X in ACC1
	call	SUB16		; ACC2 = ACC1 - ACC2 = P2X - P1X = DeltaX
	movf	ACC2L,W		; 
	movwf	DELXL		;
	movf	ACC2H,W		;
	movwf	DELXH		; DELX = P2x - P1x = Differenz der Punkte in X Richtung
	
	; Differenz in Y-Richtung bilden
	movf	P1YL,W		;
	movwf	ACC2L		;
	movf	P1YH,W		;
	movwf	ACC2H		; P1Y in ACC2
	movf	P2YL,W		;
	movwf	ACC1L		;
	movf	P2YH,W		;
	movwf	ACC1H		; P2Y in ACC1
	call	SUB16		; ACC2 = ACC1 - ACC2 = P2Y - P1Y = DeltaY
	movf	ACC2L,W		; 
	movwf	DELYL		;
	movf	ACC2H,W		;
	movwf	DELYH		; DELY = P2Y - P1Y = Differenz der Punkte in Y Richtung

	; Da gilt P2x > P1X reduziert sich die Fallunterscheidung in 2 Flle
	; 1. Delta-Y positiv oder negativ
	; 2. Steigung grer 1 oder Steigung kleiner 1

	clrf	SLOSTAT		; Status-Register lschen, da neuer Sttzpunkt
	btfss	DELYH,7		; Delta-Y negativ ?
	goto	NEWST1		;
	bsf	SLOSTAT,0	; ja, also im Bit 0 des Statusregisters merken sowie dy:=-dy
	comf	DELYH,F		; High invertieren
	comf	DELYL,W		; Low invertieren
	addlw	0x01		; eins drauf
	movwf	DELYL		; Low um eins erhhen
	btfsc	STATUS,CARRY	; ueberlauf ?
	incf	DELYH,F		; High um eins erhhen 
	goto	NEWST1		;
	
NEWST1	; Steigung prfen
	movf	DELYL,W		;
	movwf	ACC2L		;
	movf	DELYH,W		;
	movwf	ACC2H		; DELY in ACC2
	movf	DELXL,W		;
	movwf	ACC1L		;
	movf	DELXH,W		;
	movwf	ACC1H		; DELX in ACC1
	call	SUB16		; ACC2 = ACC1 - ACC2 = DELX - DELY
	btfss	ACC2H,7		; Wenn Bit 7 auf 1, dann negative Zahl (+:m<1,0:m=1,-:m>1)
	goto	NEWST2		; m<=1 also weiter
	bsf	SLOSTAT,1	; da m>1 den Merker setzen
	;
	; Routine zur Korrektur der Werte wenn m>1 ist
	;
	clrf	CORRH		;
	clrf	CORRL		; Korrektur auf 0 setzen
	movf	DELYL,W		;
	movwf	ACC2L		;
	movf	DELYH,W		;
	movwf	ACC2H		; DELY in ACC2
	movf	DELXL,W		;
	movwf	ACC1L		;
	movf	DELXH,W		;
	movwf	ACC1H		; DELX in ACC1
NEWST4	call	SUB162		; ACC2 = ACC2 - ACC1 = DELY - DELX
	btfsc	ACC2H,7		; Negativ geworden ?
	goto	NEWST5		; ja, also eins zuviel
	movf	DELXL,W		;
	movwf	ACC1L		; reparieren da berschrieben worden
	movf	DELXH,W		;
	movwf	ACC1H		; reparieren da berschrieben worden
	movf	CORRL,W		; CORR nach W
	addlw	0x01		; eins addieren
	movwf	CORRL		; und zurck
	btfsc	STATUS,CARRY	; Ueberlauf ?
	incf	CORRH,F		; dann Uebertrag
	goto	NEWST4		; weiter subtrahieren
	

NEWST5	movf	DELXL,W		;
	movwf	ACC1L		; reparieren da berschrieben worden
	movf	DELXH,W		;
	movwf	ACC1H		; reparieren da berschrieben worden
	call	ADD16		; DELY einmal DELX dazu
	; in ACC2 ist nun der Rest von DELY
	; in CORR ist nun der Korrektur-Wert
	movf	ACC2L,W		;
	movwf	DELYL		; das ist das neue Delta Y
	movf	ACC2H,W		;
	movwf	DELYH		; das ist das neue Delta Y
		
	; CORR enthlt den Korrekturwert, neues DeltaY sowie P2Y ist bekannt
	; jetzt noch korrigieren, wenn die Steigung negativ ist muss CORR auch negativ sein
	btfss	SLOSTAT,0	;
	goto	NEWST2		; positiv, na denn weiter
	comf	CORRH,F		; High invertieren
	comf	CORRL,W		; Low invertieren
	addlw	0x01		; eins addieren
	movwf	CORRL		; Ergebnis ablegen
	btfsc	STATUS,CARRY	; berlauf ?
	incf	CORRH,F		; Dann eins rauf
	goto	NEWST2		; und weiter bei NOWST2

NEWST2	; Nun sind alle Werte bekannt, Die Vorbereitung fr Bresenham kann losgehen
	; mit Berechnung von a, b, e
	; a := dy shl 1;
	movf	DELYL,W		; DELY nach ACC1
	movwf	ACC1L		;
	movf	DELYH,W		;
	movwf	ACC1H		; 
	call	DOP16		; ACC1 = ACC1*2
	movf	ACC1L,W		;
	movwf	TEMAL		;
	movf	ACC1H,W		;
	movwf	TEMAH		; ACC1 nach TEMA
   	; b := dx shl 1 - a;
	movf	DELXL,W		; DELX nach ACC1
	movwf	ACC1L		;
	movf	DELXH,W		;
	movwf	ACC1H		; 
	call	DOP16		; ACC1 = ACC1*2, Ergebnis gleich in ACC1 lassen
	movf	TEMAL,W		; TEMA nach ACC2
	movwf	ACC2L		;
	movf	TEMAH,W		;
	movwf	ACC2H		;
	call	SUB16		; ACC2 = ACC1 - ACC2 = DELX shl1 - TEMA
	movf	ACC2L,W		;
	movwf	TEMBL		;
	movf	ACC2H,W		;
	movwf	TEMBH		; ACC2 nach TEMB
   	; e := a - dx;
	movf	DELXL,W		; DELX nach ACC2
	movwf	ACC2L		;
	movf	DELXH,W		;
	movwf	ACC2H		;
	movf	TEMAL,W		; TEMA nach ACC1
	movwf	ACC1L		;
	movf	TEMAH,W		;
	movwf	ACC1H		;
	call	SUB16		; ACC2 = ACC1 - ACC2 = TEMA - DELX
	movf	ACC2L,W		;
	movwf	TEMEL		;
	movf	ACC2H,W		;
	movwf	TEMEH		; ACC2 nach TEME

	; Prfen, obs der erste Datenpunkt ist. Sonst keine Ausgabe
	movf	P1XH,W		;
	btfss	STATUS,ZERO
	goto	NEWST7
	movf	P1XL,W		;
	btfss	STATUS,ZERO
	goto	NEWST7
	
	btfsc	PROGST,0	; CH1 oder CH2 ?
	goto	NEWSTCH2	;
	goto	NEWSTCH1	;

NEWSTCH2 ; CH2 Wert 
	movf	P1YH,W		; 
	movwf	REZIPH		;
	movf	P1YL,W		;
	movwf	REZIPL		;
	call	REZIP		; Frequenz in Zeit umrechnen

	movf	REZIPH,W	; Versuch x 3
	movwf	CH2NEWH		;
	movf	REZIPL,W	;	
	movwf	CH2NEWL		;
	
	bcf	STATUS,CARRY	;
	rlcf	REZIPL,F	;
	rlcf	REZIPH,F
	
	movf	REZIPL,W	;
	addwf	CH2NEWL,F	;
	btfsc	STATUS,CARRY	;
	incf	CH2NEWH,F	;
	movf	REZIPH,W	;
	addwf	CH2NEWH,F	; Versuch x 3

	movlw   0x0A		; ca. 10 Zyklen abziehen wegen der internen Verarbeitung !
        subwf   CH2NEWL,F	;
        movlw   0x00		;
        btfss   STATUS,CARRY	;
        movlw   0x01		; 
        subwf   CH2NEWH,F       ; 
		
	comf	CH2NEWH,F	; Komplement also $FFFF - Act-Wert = Rest-Zeit bis berlauf
	comf	CH2NEWL,F	;

	bsf	PROGST,2	; Neuer Wert zum Abholen bereit
	goto	NEWST7		; Schleife verlassen
	
NEWSTCH1 ; CH1 Wert 
	movf	P1YH,W		; 
	movwf	REZIPH		;
	movf	P1YL,W		;
	movwf	REZIPL		;
	call	REZIP		; Frequenz in Zeit umrechnen
        
        movf	REZIPH,W	; Versuch x 3
	movwf	CH1NEWH		;
	movf	REZIPL,W	;	
	movwf	CH1NEWL		;
	
	bcf	STATUS,CARRY	;
	rlcf	REZIPL,F	;
	rlcf	REZIPH,F
	
	movf	REZIPL,W	;
	addwf	CH1NEWL,F	;
	btfsc	STATUS,CARRY	;
	incf	CH1NEWH,F	;
	movf	REZIPH,W	;
	addwf	CH1NEWH,F	; Versuch x 3
	
	movlw   0x0A		; ca. 10 Zyklen abziehen wegen der internen Verarbeitung !
        subwf   CH1NEWL,F	;
        movlw   0x00		;
        btfss   STATUS,CARRY	;
        movlw   0x01		; 
        subwf   CH1NEWH,F       ; 
               
	comf	CH1NEWH,F	; Komplement also $FFFF - Act-Wert = Rest-Zeit bis berlauf
	comf	CH1NEWL,F	;
	
	bsf	PROGST,1	; Neuer Wert zum Abholen bereit
	goto	NEWST7		; Schleife verlassen

NEWST7	return			; zurck zur aufrufenden Routine
	
;*************************************************************************
; MSLOOP - Millisekunden-Loop
;
; Input		P1XL, P1XH, P1YL, P1YH, P2XL, P2XH, P2YL, P2YH : 2 Sttzpunkte, P1 "aelter", P2 "neuer"
; 		DELXL, DELXH, DELYL, DELYH : Sttzpunkt-Differenz
;		SLOSTAT : Status-Register der Slope-Detect-Routine
; 			  Y-Schrittrichtung positiv(0:0) oder negativ(0:1)
;			  Steigung kleiner eins (1:0) oder grer eins (1:1)
;		TEMAL, TEMAH, TEMBL, TEMBH, TEMEL, TEMEH : Temporre Speicher fr a,b,e bei Bresenham
;		
;*************************************************************************

MSLOOP	btfsc	PROGST,0	; Ch1 ?
	call	SWAPAB		; CH2, also Register tauschen
	
	; Endlos-Schleife mit Bresenham-Algorithmus
	; x := x + 1
	; if e > 0 then
	;	y := y + ystep (wobei ystep +1 bei SLOSTAT0=0 und -1 bei SLOSTAT=1)
	;	e := e - b
	; else
	;	e := e + a
	; Neuer Punkt x,y wird in P1X/P1Y gespeichert	
	
	; x := x + 1
	movf	P1XL,W		;
	addlw	0x01		; eins rauf
	movwf	P1XL		; P1X um eins erhhen
	btfsc	STATUS,CARRY	; Gabs berlauf ?
	incf	P1XH,F		; Ja, also im High eins rauf

	; letzter Zwischenschritt erreicht ?
	movf	P1XL,W		;
	xorwf	P2XL,W		;
	btfss	STATUS,ZERO	; gleich ?
	goto	MSLOOP8		;
	movf	P1XH,W		;
	xorwf	P2XH,W		; gleich ?
	btfss	STATUS,ZERO	;
	goto	MSLOOP8
	; der alte P2 wird nun zum neuen P1 und die Ausleseschleife wird neu gestartet
	movf	P2YL,W		;
	movwf	P1YL		;
	movf	P2YH,W		;
	movwf	P1YH		; 
	movf	P2XL,W		;
	movwf	P1XL		;
	movf	P2XH,W		;
	movwf	P1XH		; 
	call	NEWST		;
	goto	MSLOOPB		;
	;

MSLOOP8	; if e > 0 then
	btfsc	TEMEH,7		; Sign Bit gesetzt ?
	goto	MSLOOP1		; gesetzt, also negativ, damit nicht 0
	movf	TEMEL,W		; TEME Low nach W,
	btfsc	STATUS,ZERO	; 0 ?
	goto	MSLOOP1		; gesetzt, also 0, damit nicht grer 0
	; ist >0 also weiter 

MSLOOP2	; e > 0, also y:=y+ystep, e:=e-b
	btfsc	SLOSTAT,0	; 0 also ist ystep=+1 		
	goto	MSLOOP3		; ystep=-1
	movf	P1YL,W		;
	addlw	0x01		;
	movwf	P1YL		; um eins rauf
	btfsc	STATUS,CARRY	; Gabs berlauf ?
	incf	P1YH,F		; Ja, also im High auch eins rauf
	goto	MSLOOP4		; weiter zu e-Berechnung

MSLOOP3	; ystep=-1
	movf	P1YL,W		; zum Test nach W
	btfss	STATUS,ZERO	; ist es schon 0 ?
	goto	MSLOOP5		; ein, also eins abziehen geht
	comf	P1YL,F		; ist 0, also P1YL invertieren, und bei P1YH eins weg
	decf	P1YH,F		; also beim High eins weg
	goto	MSLOOP4		; weiter zur e-berechnung	

MSLOOP5	; eins abziehen
	decf	P1YL,F		;
	goto	MSLOOP4		; weiter zur e-berechnung

MSLOOP4	; e:=e-b
	movf	TEMBL,W		; TEMB nach ACC2
	movwf	ACC2L		;
	movf	TEMBH,W		;
	movwf	ACC2H		;
	movf	TEMEL,W		; TEME nach ACC1
	movwf	ACC1L		;
	movf	TEMEH,W		;
	movwf	ACC1H		;
	call	SUB16		; ACC2 = ACC1 - ACC2 = TEME - TEMB
	movf	ACC2L,W		;
	movwf	TEMEL		;
	movf	ACC2H,W		;
	movwf	TEMEH		; ACC2 nach TEME
	goto	MSLOOPX		; weiter bei MSLOOPX

MSLOOP1	; e <=0, also e := e + a;
	movf	TEMEL,W		; TEME nach ACC2
	movwf	ACC2L		;
	movf	TEMEH,W		;
	movwf	ACC2H		;
	movf	TEMAL,W		; TEMA nach ACC1
	movwf	ACC1L		;
	movf	TEMAH,W		;
	movwf	ACC1H		;
	call	ADD16		; ACC2 = ACC1 + ACC2 = TEMA + TEME
	movf	ACC2L,W		;
	movwf	TEMEL		;
	movf	ACC2H,W		;
	movwf	TEMEH		; ACC2 nach TEME	
	goto	MSLOOPX		; weiter bei MSLOOPX

MSLOOPX	; Ausgabe des aktuellen Wertes. Dieser ist in P1X, P1Y
	; Muss der Korrektur-Wert angewendet werden ?
	btfss	SLOSTAT,1	; bei 1 ja
	goto	MSLOOPB		; nein, dann Punkt direkt ausgeben
	; P1Y := P1Y + CORR
	movf	CORRL,W		; CORR nach ACC1
	movwf	ACC1L		;
	movf	CORRH,W		;
	movwf	ACC1H		;
	movf	P1YL,W		; P1Y nach ACC2
	movwf	ACC2L		;
	movf	P1YH,W		;
	movwf	ACC2H		;
	call	ADD16		; ACC2 = ACC1 + ACC2 = P1Y + CORR = P1Y neu
	movf	ACC2L,W		;
	movwf	P1YL		;
	movf	ACC2H,W		;
	movwf	P1YH		; neuer P1Y-Wert	
	goto	MSLOOPB		; CORR angewendet, also weiter (war mal MSLOOP7)
	
MSLOOPB	btfsc	PROGST,0	; CH1 oder CH2 ?
	goto	MSLOOPCH2	;
	goto	MSLOOPCH1	;

MSLOOPCH2 ; CH2 Wert 
	movf	P1YH,W		; 
	movwf	REZIPH		;
	movf	P1YL,W		;
	movwf	REZIPL		;
	call	REZIP		; Frequenz in Zeit umrechnen

	movf	REZIPH,W	; Versuch x 3
	movwf	CH2NEWH		;
	movf	REZIPL,W	;	
	movwf	CH2NEWL		;
	
	bcf	STATUS,CARRY	;
	rlcf	REZIPL,F	;
	rlcf	REZIPH,F
	
	movf	REZIPL,W	;
	addwf	CH2NEWL,F	;
	btfsc	STATUS,CARRY	;
	incf	CH2NEWH,F	;
	movf	REZIPH,W	;
	addwf	CH2NEWH,F	; Versuch x 3

	movlw   0x0A		; ca. 10 Zyklen abziehen wegen der internen Verarbeitung !
        subwf   CH2NEWL,F	;
        movlw   0x00		;
        btfss   STATUS,CARRY	;
        movlw   0x01		; 
        subwf   CH2NEWH,F       ; 
		
	comf	CH2NEWH,F	; Komplement also $FFFF - Act-Wert = Rest-Zeit bis berlauf
	comf	CH2NEWL,F	;

	bsf	PROGST,2	; Neuer Wert zum Abholen bereit
	goto	MSLOOPA		; Schleife verlassen
	
MSLOOPCH1 ; CH1 Wert 
	movf	P1YH,W		; 
	movwf	REZIPH		;
	movf	P1YL,W		;
	movwf	REZIPL		;
	call	REZIP		; Frequenz in Zeit umrechnen
        
        movf	REZIPH,W	; Versuch x 3
	movwf	CH1NEWH		;
	movf	REZIPL,W	;	
	movwf	CH1NEWL		;
	
	bcf	STATUS,CARRY	;
	rlcf	REZIPL,F	;
	rlcf	REZIPH,F
	
	movf	REZIPL,W	;
	addwf	CH1NEWL,F	;
	btfsc	STATUS,CARRY	;
	incf	CH1NEWH,F	;
	movf	REZIPH,W	;
	addwf	CH1NEWH,F	; Versuch x 3
	
	movlw   0x0A		; ca. 10 Zyklen abziehen wegen der internen Verarbeitung !
        subwf   CH1NEWL,F	;
        movlw   0x00		;
        btfss   STATUS,CARRY	;
        movlw   0x01		; 
        subwf   CH1NEWH,F       ; 
               
	comf	CH1NEWH,F	; Komplement also $FFFF - Act-Wert = Rest-Zeit bis berlauf
	comf	CH1NEWL,F	;
	
	bsf	PROGST,1	; Neuer Wert zum Abholen bereit
	bsf	PROGST,0	; auf CH2 schalten
	goto	MSLOOP		; nochmal durchfahren
		
MSLOOPA	bcf	PROGST,0	; auf Ch1 schalten
	call	SWAPAB		; und CH2/1 tauschen
	
	RETURN
	
;*************************************************************************
; ADD16 - Addition von zwei 16Bit signed Integer Zahlen
;
; Input		ACC1L, ACC1H, ACC2L, ACC2H
; Output	ACC2L, ACC2H
;*************************************************************************

ADD16	movf	ACC1L,W		; Low byte laden
	addwf	ACC2L,F		; anderes Low dazuaddieren
	btfsc	STATUS,CARRY	; gabs Ueberlauf ?
	incf	ACC2H,F		; ja, dann High um eins rauf 
	movf	ACC1H,W		; High laden
	addwf	ACC2H,F		; anderes High dazuaddieren
	return			; zurueck zum Aufruf

;*************************************************************************
; SUB16 - Subtraktion von zwei 16Bit signed Integer Zahlen
;	  (Addition mit negierter Zahl (Invertieren + 1)), ACC2 = ACC1 - ACC2
; Input		ACC1L, ACC1H, ACC2L, ACC2H
; Output	ACC2L, ACC2H
;*************************************************************************

; SUB16 ist ACC2 = ACC1 - ACC2
SUB16	comf	ACC2H,F		; High invertieren
	comf	ACC2L,W		; Low invertieren
	addlw	0x01		; eins addieren
	movwf	ACC2L		; Ergebnis ablegen
	btfsc	STATUS,CARRY	; berlauf ?
	incf	ACC2H,F		; Dann eins rauf
	movf	ACC1L,W		; Low byte laden
	addwf	ACC2L,F		; anderes Low dazuaddieren
	btfsc	STATUS,CARRY	; gabs Ueberlauf ?
	incf	ACC2H,F		; ja, dann High um eins rauf
	movf	ACC1H,W		; High laden
	addwf	ACC2H,F		; anderes High dazuaddieren
	return			; zurueck zum Aufruf

; SUB162 ist ACC2 = ACC2 - ACC1	
SUB162	comf	ACC1H,F		; High invertieren
	comf	ACC1L,W		; Low invertieren
	addlw	0x01		; eins addieren
	movwf	ACC1L		; Ergebnis ablegen
	btfsc	STATUS,CARRY	; berlauf ?
	incf	ACC1H,F		; Dann eins rauf
	movf	ACC1L,W		; Low byte laden
	addwf	ACC2L,F		; anderes Low dazuaddieren
	btfsc	STATUS,CARRY	; gabs Ueberlauf ?
	incf	ACC1H,F		; ja, dann High um eins rauf ##### ??
	movf	ACC1H,W		; High laden
	addwf	ACC2H,F		; anderes High dazuaddieren
	return			; zurueck zum Aufruf
		
;*************************************************************************
; DOP16 - Multiplikation mit 2 einer 16Bit signed Integer Zahl
;
; Input		ACC1L, ACC1H
; Output	ACC1L, ACC1H
;*************************************************************************

DOP16	btfsc	ACC1H,7		; Vorzeichen nach rechts kopieren
	bsf	ACC1H,6		;
	btfss	ACC1H,7		; Vorzeichen nach rechts kopieren
	bcf	ACC1H,6		;
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	ACC1H,F		; High Byte links schieben
	bcf	STATUS,CARRY	; CARRY loeschen
	rlcf	ACC1L,F		; Low Byte links schieben
	btfsc	STATUS,CARRY	; Ueberlauf ?
	incf	ACC1H,F		; eins im High rauf
	return			; zurueck zum Aufruf

;*************************************************************************
; MUL10 - Multiplikation einer 16Bit unsigned Integer Zahl mal 10
;
; Input		ACC1L, ACC1H
; Output	ACC1L, ACC1H (Achtung, T05(L) / T06(H) wird als Temp verwendet!)
;
; ACC1*10 = ACC1 * 2 + ACC1 * 8
;*************************************************************************

MUL10	bcf	STATUS,CARRY	; Carry loeschen
	rlcf	ACC1L,F		;
	rlcf	ACC1H,F		; ACC1*2
	movf	ACC1L,W		;
	movwf	T05		; in T05 zwischenspeichern
	movf	ACC1H,W		;
	movwf	T06		; in T06 zwischenspeichern
	bcf	STATUS,CARRY	;
	rlcf	ACC1L,F		;
	rlcf	ACC1H,F		; ACC1*2
	bcf	STATUS,CARRY	;
	rlcf	ACC1L,F		;
	rlcf	ACC1H,F		; ACC1*2
	movf	T05,W		;
	addwf	ACC1L,F		; Low T05 + ACC1
	btfsc	STATUS,CARRY	;
	incf	ACC1H,F		;
	movf	T06,W		;
	addwf	ACC1H,F		; High T06 + ACC1
	return			; zurueck zum Aufruf

;*************************************************************************
; DIVAB - Division von 2x 16Bit unsigned integer Zahlen
;
; http://www.mcmanis.com/chuck/robotics/projects/ServoGizmo/software/div16.asm
;
; Input		ACC1L,ACC1H,ACC2L,ACC2H  (ACC1 : Dividend, ACC2 : Divisor)
; Output        ACC1L,ACC1H,ACC2L,ACC2H,ACC3L,ACC3H (ACC1 : Remainder, ACC2 : Divisor, ACC3 : RESULT)
; Temporr wird T06 benutzt
;*************************************************************************

DIVAB   clrf    ACC3L           ; Result lschen
        clrf    ACC3H           ; Result lschen
        movlw   0x01            ;
        movwf   T06             ; Counter auf 1
DIVAB1  btfsc   ACC2H,7         ; Divisor hchstes Bit gesetzt ?
        goto    DIVAB2          ; weitermachen
        incf    T06,F           ; Counter := Counter + 1
        bcf     STATUS,CARRY    ; Carry lschen
        rlcf    ACC2L,F         ;
        rlcf    ACC2H,F         ; Divisor links schieben
        bcf	STATUS,CARRY	; ## new
        goto    DIVAB1          ;
DIVAB2  bcf     STATUS,CARRY    ; Carry lschen
        rlcf    ACC3L,F         ;
        rlcf    ACC3H,F         ; Result links schieben
	bcf	STATUS,CARRY	; ## new
	movf    ACC2L,W		;
        subwf   ACC1L,F		;
        movf    ACC2H,W		;
        btfss   STATUS,CARRY	;
        incfsz	ACC2H,W		; ## achtung, steht in der anderen routine mit incf !
        subwf   ACC1H,F         ; 
        btfsc   STATUS,CARRY    ; Wurde es kleiner ?   
        goto    DIVAB3          ; Nein, also wars kleiner als
        bcf	STATUS,CARRY	; ## new
        movf	ACC2L,W		; Subtraktion von vorhin rckgngig
	addwf	ACC1L,F		;
	movf	ACC2H,W		;
	btfsc	STATUS,CARRY	;
	incf	ACC2H,W		;
	addwf	ACC1H,F		; Divisor = Divisor + Dividend
	goto    DIVAB4          ; weitermachen
DIVAB3  bsf     ACC3L,0         ; 1 bit setzen
DIVAB4  decf    T06,F           ; Counter := Counter - 1
        btfsc   STATUS,ZERO     ; Wenn nicht 0
        return		        ; fertig !
        bcf     STATUS,CARRY    ; Carry lschen
        rrcf    ACC2H,F         ;
        rrcf    ACC2L,F         ; Divisor rechts schieben
        goto    DIVAB2          ; nchstes Bit

;*************************************************************************
; REZIP - Teilung 10000/x, damit errechnen der Zeit[us] = 1/Frequenz
;
; Input		REZIPL, REZIPH (Frequenz in Hz*2)
; Output	REZIPL, REZIPH (Zeit in us)
;
; Temporr wird T06, ACC1..3, Hund,Tens,Ones benutzt
;*************************************************************************

REZIP	; Prfung ob Frequenz <=40 (20Hz) ist. Dort kommt es dann zum berlauf
	; beim Remainder. Deswegen wird bei Frequenzen <=40 die
	; Frequenz mal 10 genommen und die sptere Ausfhrungsschleife
	; muss dann 10mal mehr durchgefhrt werden.
	
	; hier fehlt noch die Abfrage ob Frequenz <4 (2Hz) ist, dann Routine
	; mit 1ms Wert verlassen und die Timer auf off
	
	movf	REZIPH,W	; High-byte 0 ?
	btfss	STATUS,ZERO	;
	goto	REZIP43		;
	movlw	0x04		;
	subwf	REZIPL,W	;
	btfsc	STATUS,CARRY	; schauen, ob Low < $04 ist
	goto	REZIP5		;
	movlw	0x0B		; Frequenz ist zu klein, also ausschalten
	movwf	REZIPH		; und alle Millisekunde mal nach neuem Wert
	movlw	0xB8		; horchen
	movwf	REZIPL		; 
	
	btfss	PROGST,0	; CH1 ?
	bcf	PROGST2,1	; CH1 wieder auf Normalfrequenz
	btfsc	PROGST,0	; CH2 ?
	bcf	PROGST2,2	; CH2 wieder auf Normalfrequenz
	
	btfss	PROGST,0	; CH1 ?
	bsf	PROGST2,5	; CH1 Keine Ausgabe mehr
	btfsc	PROGST,0	; CH2 ?
	bsf	PROGST2,6	; CH2 Keine Ausgabe mehr
	return			; 
		
REZIP5	movlw	0x28		;
	subwf	REZIPL,W	;
	btfsc	STATUS,CARRY	; schauen, ob Low < $28 (40dez) ist
	goto	REZIP43		; nix manipulieren
	
	; Merken, welcher Kanal eine kleine Frequenz hat

	btfss	PROGST,0	; CH1 ?
	bsf	PROGST2,1	; CH1 < 	

	btfsc	PROGST,0	; CH2 ?
	bsf	PROGST2,2	; CH2 <
	
	movf	REZIPH,W	;
	movwf	ACC1H		;
	movf	REZIPL,W	;
	movwf	ACC1L		;
	call	MUL10		; REZIP nach ACC1, dann mal 10, dann wieder nach REZIP
	movf	ACC1H,W		;
	movwf	REZIPH		;
	movf	ACC1L,W		;
	movwf	REZIPL		;
	goto	REZIP4

REZIP43	btfss	PROGST,0	; CH1 war nicht < als xx
	bcf	PROGST2,1	; CH1 Teiler lschen	
	btfsc	PROGST,0	; CH2 war nicht < als xx
	bcf	PROGST2,2	; CH2 Teiler lschen

REZIP4	btfss	PROGST,0	; CH1 ?
	bcf	PROGST2,5	; CH1 Ausgabe aktivieren
	btfsc	PROGST,0	; CH2 ?
	bcf	PROGST2,6	; CH2 Ausgabe aktivieren

	clrf	HUND		;
	clrf	TENS		;
	clrf	ONES		; Zwischenregister zurcksetzen

	movlw	0x27		;
	movwf	ACC1H		;
	movlw	0x10		;
	movwf	ACC1L		; Dividend laden 10.000 in ACC1
	movf	REZIPH,W	;
	movwf	ACC2H		;
	movf	REZIPL,W	;
	movwf	ACC2L		; Divisor laden in ACC2
	call	DIVAB		; Division durchfhren
	movf	ACC3L,W		;
	movwf	HUND		; Ergebnis in Hunderter ablegen
		
	movf	ACC1L,W		; 
	iorwf	ACC1H,W		;
	btfsc	STATUS,ZERO	; Remainder ist 0 ?
	goto	REZIP2		; fertig
	call	MUL10		; Remainder in ACC1 * 10
	call	DIVAB		; Division durchfhren
	movf	ACC3L,W		;
	movwf	TENS		; Ergebnis in Zehner ablegen

	movf	ACC1L,W		; 
	iorwf	ACC1H,W		; 
	btfsc	STATUS,ZERO	; Remainder ist 0 ?
	goto	REZIP2		; fertig	
	
	; Achtung ! Wenn Remainder >6553 ist kommt es bei der *10 zum Fehler !
	; Dann wird der Trick angewendet, das beide Zahlen /2 geteilt werden vor der
	; weiteren Rechnung. Da es die letzte Stelle ist, ist weitere Genauigkeit
	; nicht ntig
	
	; Vergleich ob >6553
	; falls ja, dann Remainder und Divisor durch 2 Teilen
	; falls nein, normal weitermachen	
	
	movlw	0x19		;
	subwf	ACC1H,W		;
	btfss	STATUS,CARRY	; schauen, ob High >= $19 (6400dez) ist
	goto	REZIP3		; nix manipulieren
	; ACC1 enthlt Remainder, ACC2 den Divisor
	bcf     STATUS,CARRY    ; Carry lschen
        rrcf    ACC2H,F         ;
        rrcf    ACC2L,F         ; Divisor rechts schieben
	bcf     STATUS,CARRY    ; Carry lschen
        rrcf    ACC1H,F         ;
        rrcf    ACC1L,F         ; Remainder rechts schieben
        bcf	STATUS,CARRY	; Carry lschen
        		
REZIP3	call	MUL10		; Remainder in ACC1 * 10
	call	DIVAB		; Division durchfhren
	movf	ACC3L,W		;
	movwf	ONES		; Ergebnis in Einser ablegen

REZIP2	call	BCDBIN		;
	return			;
	
;*************************************************************************
; BCDBIN - Wandelt eine BCD-Zahl in Binary um (Achtung : Hundreds >9 mglich!)
;
; Input		HUND,TENS,ONES
; Output	REZIPL, REZIPH (Achtung, ACC1/ACC2/ACC3 als Temp)
;
; ACC1 := Hundreds [one byte]
; ACC1 := ACC1 MUL10
; ACC1 := ACC1 MUL10
; REZIP := ACC1
; ACC1 := Tenes [one byte]
; ACC1 := ACC1 MUL10
; REZIP := REZIP + ACC1
; REZIP := REZIP + Ones [one byte]
; 
;*************************************************************************

BCDBIN	clrf	REZIPL		;
	clrf	REZIPH		;
	movf	HUND,W		; Hundreds nach ACC1
	movwf	ACC1L		;
	clrf	ACC1H		;
	call	MUL10		; ACC1 * 10
	call	MUL10		; ACC1 * 10
	movf	ACC1L,W		;
	movwf	REZIPL		;
	movf	ACC1H,W		;
	movwf	REZIPH		; REZIP = ACC1 (Hundreds * 100)
	movf	TENS,W		; Tens nach ACC1
	movwf	ACC1L		;
	clrf	ACC1H		;
	call	MUL10		; ACC1 * 10
	
	movf	ACC1L,W		;
	addwf	REZIPL,F	;
	btfsc	STATUS,CARRY	;
	incf	ACC1H,F		;
	movf	ACC1H,W		;
	addwf	REZIPH,F	; REZIP := REZIP + ACC1 (Tens * 10)

	movf	ONES,W		;
	addwf	REZIPL,F	;
	btfsc	STATUS,CARRY	;
	incf	REZIPH,F	; REZIP := REZIP + Ones
			
	return			; zurueck zum Aufruf

;*************************************************************************
; CONV - Konvertiert eine 16bit Zahl in BCD-Ziffern welche als ASCII ausgegeben werden
; Routine von John Payson
; http://www.dattalo.com/technical/software/pic/bcd.txt
; Input		NUMH, NUML
; Output	TENK,THOU,HUND,TENS,ONES
;*************************************************************************

CONV	btfss	NUMH,7		; Sign Bit gesetzt ? Prfen ob negativ
	goto	CONV1		; nein, dann normal weiter

	movlw	0x2D		; ASCII Minus
	call	SENDRS		; Serielle Ausgabe

	comf	NUMH,F		; invertieren
	comf	NUML,W		; invertieren
	addlw	0x01		; eins drauf
	movwf	NUML		;
	btfsc	STATUS,CARRY	; berlauf ?
	incf	NUMH,F		; dann bei High eins drauf 
	
CONV1	swapf   NUMH,w
        andlw   0x0F             
        addlw   0xF0             
        movwf   THOU
        
        addwf   THOU,f
        addlw   0xE2
        movwf   HUND
        addlw   0x32
        movwf   ONES

        movf    NUMH,w
        andlw   0x0F
        addwf   HUND,f
        addwf   HUND,f
        addwf   ONES,f
        addlw   0xE9
        movwf   TENS
        addwf   TENS,f
        addwf   TENS,f

        swapf   NUML,w
        andlw   0x0F
        addwf   TENS,f
        addwf   ONES,f

        rlcf    TENS,f
        rlcf    ONES,f
        comf    ONES,f
        rlcf    ONES,f

        movf    NUML,w
        andlw   0x0F
        addwf   ONES,f

        rlcf    THOU,f

        movlw   0x07
        movwf   TENK

        movlw   0x0A 
                

LB1XX   decf    TENS,f
        addwf   ONES,f
        btfss   STATUS,CARRY
        goto   	LB1XX

LB2XX   decf    HUND,f
        addwf   TENS,f
        btfss   STATUS,CARRY
        goto   	LB2XX

LB3XX   decf    THOU,f
        addwf   HUND,f
        btfss   STATUS,CARRY
        goto   	LB3XX

LB4XX   decf    TENK,f
        addwf   THOU,f
        btfss   STATUS,CARRY
        goto   	LB4XX

	; Konvertierung fertig, jetzt noch in ASCII wandeln

	movf	TENK,W		; Zehntausender holen
	addlw	0x30		; 48 drauf
	call	SENDRS		; Serielle Ausgabe
	movf	THOU,W		; Tausender holen
	addlw	0x30		; 48 drauf
	call	SENDRS		; Serielle Ausgabe
	movf	HUND,W		; Hunderter holen
	addlw	0x30		; 48 drauf
	call	SENDRS		; Serielle Ausgabe
	movf	TENS,W		; Zehner holen
	addlw	0x30		; 48 drauf
	call	SENDRS		; Serielle Ausgabe
	movf	ONES,W		; Einser holen
	addlw	0x30		; 48 drauf
	call	SENDRS		; Serielle Ausgabe
	
	movlw	0x0D
	call	SENDRS
	movlw	0x0A
	call	SENDRS

	return			; und zurueck

;*************************************************************************
; SENDRS - Sendet ein Byte auf der RS232 aus
;*************************************************************************

SENDRS	movwf	TXREG		; Daten in W 
CHECK2	btfss	TXSTA,TRMT	;
	goto	CHECK2		;	
	return			;

;*************************************************************************
; SWAPAB - Vertauscht alle Variablen fr CH1 und CH2, damit 
;         die Berechnungsroutine doppelt benutzt werden kann
;*************************************************************************

SWAPAB	movf	P1XL,W		; P1XL nach W
	movwf	T01		; W in Zwischenregister T01
	movf	P1XLB,W		; P1XLB nach W
	movwf	P1XL		; zurck nach P1XL
	movf	T01,W		; Zwischenregister in W
	movwf	P1XLB		; zurck nach P1XLB
	
	movf	P1XH,W		; P1XH
	movwf	T01		; 
	movf	P1XHB,W		; 
	movwf	P1XH		; 
	movf	T01,W		; 
	movwf	P1XHB		; 
	
	movf	P1YL,W		; P1YL
	movwf	T01		; 
	movf	P1YLB,W		; 
	movwf	P1YL		; 
	movf	T01,W		; 
	movwf	P1YLB		; 
	
	movf	P1YH,W		; P1YH
	movwf	T01		; 
	movf	P1YHB,W		; 
	movwf	P1YH		; 
	movf	T01,W		; 
	movwf	P1YHB		; 
	
	movf	P2XL,W		; P2XL
	movwf	T01		; 
	movf	P2XLB,W		; 
	movwf	P2XL		; 
	movf	T01,W		; 
	movwf	P2XLB		; 
	
	movf	P2XH,W		; P2XH
	movwf	T01		; 
	movf	P2XHB,W		; 
	movwf	P2XH		; 
	movf	T01,W		; 
	movwf	P2XHB		; 
	
	movf	P2YL,W		; P2YL
	movwf	T01		; 
	movf	P2YLB,W		; 
	movwf	P2YL		; 
	movf	T01,W		; 
	movwf	P2YLB		; 
	
	movf	P2YH,W		; P2YH
	movwf	T01		; 
	movf	P2YHB,W		; 
	movwf	P2YH		; 
	movf	T01,W		; 
	movwf	P2YHB		; 
	
	movf	DELXL,W		; DELXL
	movwf	T01		; 
	movf	DELXLB,W	; 
	movwf	DELXL		; 
	movf	T01,W		; 
	movwf	DELXLB		; 
	
	movf	DELXH,W		; DELXH
	movwf	T01		; 
	movf	DELXHB,W	; 
	movwf	DELXH		; 
	movf	T01,W		; 
	movwf	DELXHB		; 
	
	movf	DELYL,W		; DELYL
	movwf	T01		; 
	movf	DELYLB,W	; 
	movwf	DELYL		; 
	movf	T01,W		; 
	movwf	DELYLB		; 
	
	movf	DELYH,W		; DELYH
	movwf	T01		; 
	movf	DELYHB,W	; 
	movwf	DELYH		; 
	movf	T01,W		; 
	movwf	DELYHB		; 
	
	movf	SLOSTAT,W	; SLOSTAT
	movwf	T01		; 
	movf	SLOSTATB,W	; 
	movwf	SLOSTAT		; 
	movf	T01,W		; 
	movwf	SLOSTATB	; 
	
	movf	TEMAL,W		; TEMAL
	movwf	T01		; 
	movf	TEMALB,W	; 
	movwf	TEMAL		; 
	movf	T01,W		; 
	movwf	TEMALB		; 
	
	movf	TEMAH,W		; TEMAH
	movwf	T01		; 
	movf	TEMAHB,W	; 
	movwf	TEMAH		; 
	movf	T01,W		; 
	movwf	TEMAHB		; 
	
	movf	TEMBL,W		; TEMBL
	movwf	T01		; 
	movf	TEMBLB,W	; 
	movwf	TEMBL		; 
	movf	T01,W		; 
	movwf	TEMBLB		; 
	
	movf	TEMBH,W		; TEMBH
	movwf	T01		; 
	movf	TEMBHB,W	; 
	movwf	TEMBH		; 
	movf	T01,W		; 
	movwf	TEMBHB		; 
	
	movf	TEMEL,W		; TEMEL
	movwf	T01		; 
	movf	TEMELB,W	; 
	movwf	TEMEL		; 
	movf	T01,W		; 
	movwf	TEMELB		; 
	
	movf	TEMEH,W		; TEMEH
	movwf	T01		; 
	movf	TEMEHB,W	; 
	movwf	TEMEH		; 
	movf	T01,W		; 
	movwf	TEMEHB		; 
	
	movf	CORRL,W		; CORRL
	movwf	T01		; 
	movf	CORRLB,W	; 
	movwf	CORRL		; 
	movf	T01,W		; 
	movwf	CORRLB		; 
	
	movf	CORRH,W		; CORRH
	movwf	T01		; 
	movf	CORRHB,W	; 
	movwf	CORRH		; 
	movf	T01,W		; 
	movwf	CORRHB		; 
	
	movf	TABCNT,W	; TABCNT
	movwf	T01		; 
	movf	TABCNTB,W	; 
	movwf	TABCNT		; 
	movf	T01,W		; 
	movwf	TABCNTB		; 

	return			; geschafft	

;*************************************************************************
; ISR-Routine High Interrupt (Timer0/Timer1/Timer3)
; Achtung ! In einer Interrupt-Routine nie auf PORTx zugreifen sondern ber
; das Latch per LATx
;*************************************************************************

HIGHINT	movwf	WREG_TEMP2		;save working register
	movff	STATUS,STATUS_TEMP2	;save STATUS register
	movff	BSR,BSR_TEMP2		;save BSR register

HIGHTR0 btfsc	PIR1,TMR1IF	; Timer 1 berlauf ?
	goto	HIGHTR1		;
	btfsc	PIR2,TMR3IF	; Timer 3 berlauf ?
	goto	HIGHTR3		;
	goto	HIGHOUT		; Keine Timer-Interrupts mehr

HIGHTR1	incf	CH1CNT,F	; Wiederholungszhler eins rauf
	btfss	CH1CNT,4	; schon bergelaufen ?
	goto	HIGHA3		;
	
	btfss	PROGST2,5	; Darf Frequenz ausgegeben werden ?	
	BTG	LATA,0		; Dann Leitung toggeln
	movlw	0x0F		;
	btfsc	PROGST2,3	;
	movlw	0x06		; 
	movwf	CH1CNT		; Wiederholungszhler zurcksetzen
	
	btfss	PROGST,1	; Neuer Wert da ?
	goto	HIGHA3		;
	
	bcf	PROGST,1	; 
	bcf	PROGST2,3	; 
	btfsc	PROGST2,1	; 
	bsf	PROGST2,3	;  Neuer Zustand des x10 Teilers rberkopieren
	
	movf	CH1NEWH,W	;
	movwf	CH1ACTH		;
	movf	CH1NEWL,W	;
	movwf	CH1ACTL		;
			
HIGHA3	movf	CH1ACTH,W	;
	movwf	TMR1H		;
	movf	CH1ACTL,W	;
	movwf	TMR1L		;
	
	bcf	PIR1,TMR1IF	; Timer 1 Interrupt-Anzeige zurcksetzen 
	btfss	PIR2,TMR3IF	; Timer 1 berlauf ?
	goto	HIGHTR0		;
		
HIGHTR3	incf	CH2CNT,F	; Wiederholungszhler eins rauf
	btfss	CH2CNT,4	; schon bergelaufen ?
	goto	HIGHB3		;
	
	btfss	PROGST2,6	; Darf Frequenz ausgegeben werden ?
	BTG	LATA,1		; Dann Leitung toggeln
	movlw	0x0F		; 
	btfsc	PROGST2,4	;
	movlw	0x06		; 
	movwf	CH2CNT		; Wiederholungszhler zurcksetzen
	btfss	PROGST,2	; Neuer Wert da ?
	goto	HIGHB3		;

	bcf	PROGST,2	;
	bcf	PROGST2,4	; 
	btfsc	PROGST2,2	;
	bsf	PROGST2,4	; Neuer Zustand des x10 Teilers rberkopieren
	
	movf	CH2NEWH,W	; 
	movwf	CH2ACTH		;
	movf	CH2NEWL,W	;
	movwf	CH2ACTL		;
		       
HIGHB3	movf	CH2ACTH,W	;
	movwf	TMR3H		;
	movf	CH2ACTL,W	;
	movwf	TMR3L		;
		
	bcf	PIR2,TMR3IF	; Timer 3 Interrupt-Anzeige zurcksetzen 
	btfsc	PIR1,TMR1IF	; Timer 1 berlauf ?
	goto	HIGHTR0		;
	
HIGHOUT movff	BSR_TEMP2,BSR		;restore BSR register
	movf	WREG_TEMP2,W		;restore working register
	movff	STATUS_TEMP2,STATUS	;restore STATUS register
	retfie 

;*************************************************************************
; ISR-Routine Low Interrupt
; $F447 => 1ms Task, $8ACF => 10ms Task
;*************************************************************************

LOWINT	movwf	WREG_TEMP2		;save working register
	movff	STATUS,STATUS_TEMP2	;save STATUS register
	movff	BSR,BSR_TEMP2		;save BSR register
		
	btfss	INTCON,TMR0IF	; Timer 0 berlauf ?
	goto	LOWOUT		;
	
LOWTR0	movlw	0xF4		;
	movwf	TMR0H		;
	movlw	0x47		;
	movwf	TMR0L		; Timer 0 neu laden fr 1ms Task
	bcf	INTCON,TMR0IF	; Timer 0 Interrupt-Anzeige rcksetzen	
	CALL	MSLOOP		;
	btfss	P1XH,1		; 512er gesetzt ?
	bcf	LATA,2		;
	btfsc	P1XH,1		; 512er gelscht ?
	bsf	LATA,2		;
		
LOWOUT	movff	BSR_TEMP2,BSR		;restore BSR register
	movf	WREG_TEMP2,W		;restore working register
	movff	STATUS_TEMP2,STATUS	;restore STATUS register
	retfie 

;*************************************************************************
; TABELLE - Daten-Tabelle fr die einzelnen Datenpunkte
; Reihenfolge XH,XL,YH,YL, u.s.w. 
; X-Werte in Millisekunden X=0..32000
; Y-Werte sind in Hertz damit Y=0..4000
; Werte unter 2 Hz werden als "aus" gewertet
; Tabellen-Ende wird mit FF FF FF FF markiert
; Programm-Code endet zur Zeit bei ca. $0Dxx
; Tabelle ist fix festgelegt ab $1000
;*************************************************************************

TABELLE	movf	TABCNT,W	; Pointer umkopieren
	movwf	TBLPTRL		;
	
	; DIP-Schalter einlesen, welche Tabelle ?
	comf	PORTB,W		; Port B einlesen und invertieren
	andlw	b'00001111'	; obere Bits ausblenden
	addlw	0x08
	movwf	T06
	bsf	STATUS,CARRY	;
	btfss	PROGST,0	; Daten fr welchen Kanal ?
	bcf	STATUS,CARRY	;
	rlcf	T06,W		; High-Byte erstellen
	movwf	TBLPTRH		;
	movlw	0x00		;
	movwf	TBLPTRU		;
	TBLRD*			; Byte lesen und ein Schritt weiter
	incf	TABCNT,F	; Einen Eintrag rauf
	movf	TABLAT,W	;
	return			; und zurck

	ORG	1000H		; WF00, CH1
  	db	0x00,0x00,0x01,0x2C
	db	0x27,0x10,0x07,0xD0
	db	0x3A,0x98,0x00,0x00
	db	0x4E,0x20,0x07,0xD0
	db	0x75,0x30,0x01,0x2C
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1100H		; WF00, CH2
	db	0x00,0x00,0x09,0xC4
	db	0x30,0xD4,0x09,0xC4
	db	0x3A,0x98,0x01,0xF4
	db	0x61,0xA8,0x01,0xF4
	db	0x6B,0x6C,0x09,0xC4
	db	0x75,0x30,0x09,0xC4
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1200H		; WF01, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1300H		; WF01, CH2
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1400H		; WF02, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1500H		; WF02, CH2
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1600H		; WF03, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1700H		; WF03, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	1800H		; WF04, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1900H		; WF04, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	1A00H		; WF05, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1B00H		; WF05, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	1C00H		; WF06, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1D00H		; WF06, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	1E00H		; WF07, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	1F00H		; WF07, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2000H		; WF08, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2100H		; WF08, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2200H		; WF09, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2300H		; WF09, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2400H		; WF0A, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2500H		; WF0A, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2600H		; WF0B, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2700H		; WF0B, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2800H		; WF0C, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2900H		; WF0C, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2A00H		; WF0D, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2B00H		; WF0D, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2C00H		; WF0E, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2D00H		; WF0E, CH2
	db	0xFF,0xFF,0xFF,0xFF	
	ORG	2E00H		; WF0F, CH1
	db	0xFF,0xFF,0xFF,0xFF
	ORG	2F00H		; WF0F, CH2
	db	0xFF,0xFF,0xFF,0xFF
		
	END


