unit Unit1;

{$mode objfpc}{$H+}
{ Temperature Reader by DG1SFJ }

interface

uses
  Classes, SysUtils, FileUtil, TASources, TAGraph, Forms, Controls, Graphics,
  Dialogs, StdCtrls, Grids, ExtCtrls, synaser;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Memo1: TMemo;
    StringGrid1: TStringGrid;
    Timer1: TTimer;
    Timer2: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;
  ser: TBlockSerial;
  File1: TextFile;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  ser: TBlockSerial;
  i : integer;
begin
  ListBox1.Items.Clear;
  ser:=TBlockserial.Create;
  Memo1.Lines.Add ('>Start Scan');
  for i := 1 to 255 do
  begin
    ser.Connect('COM'+inttostr(i));
       if ser.Lasterror = 0 then
       begin
          Memo1.Lines.Add ('COM'+inttostr(i)+' available');
          ser.CloseSocket;
          ListBox1.Items.Append ('COM'+inttostr(i));
       end ;
  end;
  Memo1.Lines.Add ('>End Scan');
  Memo1.Lines.Add ('');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin

  If ListBox1.ItemIndex>-1 Then
  If Timer1.Enabled = False then
   begin
     ser:=TBlockserial.Create;
     Memo1.Lines.Add ('Trying to open '+ListBox1.Items.Strings[ListBox1.ItemIndex]+' ...');
     ser.Connect(ListBox1.Items.Strings[ListBox1.ItemIndex]);
     ser.Config(38400,8,'N',0,false,false);
     if ser.Lasterror = 0 then
          begin
             Memo1.Lines.Add (ListBox1.Items.Strings[ListBox1.ItemIndex]+' is open');

             ser.ConvertLineEnd := True;

             Timer1.Enabled := True;
             Timer1.Interval := 500;

             Form1.Button1.Enabled := False;
             Form1.ListBox1.Enabled := False;
             Form1.Button2.Caption := 'STOP';

             Case ListBox2.ItemIndex of
              0 : Timer2.Interval :=1000;
              1 : Timer2.Interval :=2000;
              2 : Timer2.Interval :=5000;
              3 : Timer2.Interval :=10000;
              4 : Timer2.Interval :=30000;
              5 : Timer2.Interval :=60000;
              6 : Timer2.Interval :=2*60000;
              7 : Timer2.Interval :=5*60000;
              8 : Timer2.Interval :=10*60000;
              9 : Timer2.Interval :=20*60000;
              10 : Timer2.Interval :=30*60000;
              11 : Timer2.Interval :=60*60000;
             end;

             Timer2.Enabled := True;

             AssignFile(File1, FormatDateTime('YYYYMMDD_hhnnss',Now)+'.txt');
             Rewrite(File1);

          end
        else
            begin
              Memo1.Lines.Add (ListBox1.Items.Strings[ListBox1.ItemIndex]+' failed to open');
              ser.CloseSocket;
            end;
    end
  else
   begin

             Timer1.Enabled := False;
             Timer1.Interval := 500;
             Timer2.Enabled := False;

             Form1.Button1.Enabled := True;
             Form1.ListBox1.Enabled := True;
             Form1.Button2.Caption := 'Open COM-Port';
             CloseFile(File1);
             ser.CloseSocket;
   end;

end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
   ser.CloseSocket;
   Timer1.Enabled := False;
   Timer2.Enabled := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  ser: TBlockSerial;
  i : integer;
begin
  ListBox1.Items.Clear;
  ser:=TBlockserial.Create;
  Memo1.Lines.Add ('>Start Scan');
  for i := 1 to 255 do
  begin
    ser.Connect('COM'+inttostr(i));
       if ser.Lasterror = 0 then
       begin
          Memo1.Lines.Add ('COM'+inttostr(i)+' available');
          ser.CloseSocket;
          ListBox1.Items.Append ('COM'+inttostr(i));
       end;
  end;
  Memo1.Lines.Add ('>End Scan');
  Memo1.Lines.Add ('');
  StringGrid1.Options := StringGrid1.Options + [goEditing];
end;

procedure TForm1.ListBox2Click(Sender: TObject);
begin
  Case ListBox2.ItemIndex of
              0 : Timer2.Interval :=1000;
              1 : Timer2.Interval :=2000;
              2 : Timer2.Interval :=5000;
              3 : Timer2.Interval :=10000;
              4 : Timer2.Interval :=30000;
              5 : Timer2.Interval :=60000;
              6 : Timer2.Interval :=2*60000;
              7 : Timer2.Interval :=5*60000;
              8 : Timer2.Interval :=10*60000;
              9 : Timer2.Interval :=20*60000;
              10 : Timer2.Interval :=30*60000;
              11 : Timer2.Interval :=60*60000;
             end;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin

end;

procedure TForm1.Timer1Timer(Sender: TObject);
Var t,t_temperatur,t_kennung:string;
    NewEntry, StopSearch : Boolean;
    zeilennummer : integer;
begin
  t:=ser.Recvstring(1);
  If ser.Lasterror=0 Then
  begin

    Memo1.Lines.Add (ListBox1.Items.Strings[ListBox1.ItemIndex]+' @ '+DateTimeToStr(Now)+' : '+t);

    t:=TrimRight(t);

    While Length(t) >= 17 do
    begin

      t_temperatur:=Rightstr(t,9);
      t:=Leftstr(t,Length(t)-9);
      t_kennung:=Rightstr(t,8);
      t:=Leftstr(t,Length(t)-8);
      t:=TrimRight(t);

      {Memo1.Lines.Add ('Found '+t_kennung+' : '+t_temperatur);}

      zeilennummer:=0;  NewEntry:=True; StopSearch:=False;

      Repeat

         If StringGrid1.Cells[0,Zeilennummer]=t_kennung then
           begin
             NewEntry:=False;
             StopSearch:=True;
             StringGrid1.Cells[1,Zeilennummer]:=t_temperatur;
             StringGrid1.Cells[2,Zeilennummer]:=DateTimeToStr(Now);
           end
         else
           zeilennummer:=zeilennummer+1;

      until (StringGrid1.Cells[0,Zeilennummer]='') or (StopSearch=True);

      If NewEntry=True then
        begin
           StringGrid1.Cells[0,Zeilennummer]:=t_kennung;
           StringGrid1.Cells[1,Zeilennummer]:=t_temperatur;
           StringGrid1.Cells[2,Zeilennummer]:=DateTimeToStr(Now);
        end;

    end;

    { Bekannte Sensoren dabei ? }

    zeilennummer:=0;

    Repeat

         Case StringGrid1.Cells[0,Zeilennummer] of
          '49928D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 2cm Tiefe';
    	  '5E5F8D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 5cm Tiefe';
   	  '5C758D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 10cm Tiefe';
   	  '78788D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 20cm Tiefe';
   	  'C59E8D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 50cm Tiefe';
   	  '5DAF8D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 75cm Tiefe';
          'A37D8D02' : StringGrid1.Cells[3,Zeilennummer]:='Bodentemperatur 100cm Tiefe';
          'A6B54D02' : StringGrid1.Cells[3,Zeilennummer]:='Aussentemperatur';
          '0F988D02' : StringGrid1.Cells[3,Zeilennummer]:='Fenstertemperatur';
         end;

         zeilennummer:=zeilennummer+1;

    until (StringGrid1.Cells[0,Zeilennummer]='') ;

  end;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
Var Zeilennummer : Integer;
    Tempstring : String;
begin

   Tempstring := DateTimeToStr(Now)+' : ';
   Zeilennummer:=1;

   While StringGrid1.Cells[0,Zeilennummer]<>'' do
   begin
   TempString:=Tempstring+StringGrid1.Cells[0,Zeilennummer]+' '+StringGrid1.Cells[1,Zeilennummer]+' ';
   Zeilennummer:=Zeilennummer+1;
   end;

   Writeln (File1,Tempstring);

end;

end.

