;*************************************************************************
;
;         PIC 16F1827 - Temperature Reader fr DS18S20 .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 20.12.2013
;  Status    : A1.00                Known Bugs : wird kein CRC gemacht
;  Fuses     : 
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 |   I  | nc 
; | Port A RA1 Pin 18 |   I  | nc 
; | Port A RA2 Pin 01 |   I  | nc
; | Port A RA3 Pin 02 |   I  | nc 
; | Port A RA4 Pin 03 |   I  | nc 
; | Port A RA5 Pin 04 |   I  | MCLR 
; | Port A RA6 Pin 15 |   I  | OSCILLATOR 20MHz
; | Port A RA7 Pin 16 |   I  | OSCILLATOR
; |		      |      |
; | Port B RB0 Pin 06 |   I  | nc
; | Port B RB1 Pin 07 |   I  | RX RS232 9600 Baud
; | Port B RB2 Pin 08 |   I  | TX RS232 9600 Baud
; | Port B RB3 Pin 09 |   I  | Data Leitung fr Sensoren
; | Port B RB4 Pin 10 |   I  | nc
; | Port B RB5 Pin 11 |   I  | nc
; | Port B RB6 Pin 12 |   I  | Prog
; | Port B RB7 Pin 13 |   I  | Prog
; |		      |      |
; | + Supply   Pin 14 |      |
; | - Supply   Pin 05 |      |
;
; Oszillator :  20 Mhz -> 5MHz Clockcycle => 200ns pro Zyklus
;
; DS18S20 Sensoren :
;
; 1 : 10 FD A5 53 02 08 00 4B 
; 2 : 10 A6 B5 4D 02 08 00 CC 
; 3 : 10 D1 8E 53 02 08 00 08
; 4 : 10 0A 66 53 02 08 00 D0 
; 5 : 10 C7 B5 4D 02 08 00 38 
;
;  Bsp:
;  30 00 4B 46 FF FF 0E 10 7C => 24 Grad, Count Remain 0E, Count per C 10
;
;  Temperature = 24,0 - 0.25 +  (16 - 14)/16 => 24,0 - 0,25 + 0,125 => 23,875
;
; Ergebnis-Bus-Suche (Teil No. 5) :
; 0000 1000 1110 0011 1010 1101 1011 0010 0100 0000 0001 0000 0000 0000 0001 1100
; 0    1    7    C    5    B    D    4    2    0    8    0    0    0    8    3
;
; ROMID 10 C7 B5 4D 02 08 00 38 
; SCRATCHPAD AA 00 4B 46 FF FF 0C 10 87 
; 
; 1te Charge:
; FDA553020800 
; A6B54D020800 
; D18E53020800
; 0A6653020800 
; C7B54D020800
;
; 2te Charge:
; 388290020800 
; 5C758D020800 
; 5E5F8D020800 
; 49928D020800 
; 0F988D020800 
; 78788D020800 
; BA618D020800
; C59E8D020800
; 5DAF8D020800 
; A37D8D020800
; Bis jetzt nur die ersten 3 Bytes genutzt, ergo 16,7Mio Sensoren
;
;*************************************************************************

	messg   "Using 16F1827 Pic-type, no BootLoader at 0x0FA0-FF"
	LIST    P=16F1827, F=INHX32         ; PIC Device-type & output HEX-file format 
	#include <p16F1827.inc>             ; PIC Device-type specific variable definitions
	#define   UseBankSelectReg              ; Uncomment for devices with BSR-register

	#define config1 B'00000111000010'       ;
    __CONFIG    _CONFIG1, config1
	#define config2 B'01111011111111'       ;
    __CONFIG    _CONFIG2, config2

	; Speicher ab 0x70 ist CommonRam und damit von _jeder_ Bank aus zugreifbar (0x70...0x7F)
#define temp1				0x70		; 8Bit Temp Zelle
#define temp2				0x71		; 8Bit Temp Zelle
#define temp3				0x72
#define	temp4				0x73
#define bitsstuff			0x74		; Zaehler wieviel "1" Bits gesendet wurden zwecks Bitstuffing
#define num_bytes			0x75		; Zaehler wieviel Bytes ausgegeben wurden

#define DSS_rombitindex		0x7C		; 
#define DSS_lastdiscrepancy	0x7D		; 
#define DSS_status			0x7E		; 
#define DSS_discrepancymarker 0x7F		;
#define DSS_bita			0x00		; DSS_status Bit 0 : 
#define DSS_bitb			0x01		; DSS_status Bit 1 :
#define DSS_doneflag		0x02		; DSS_status Bit 2 :
#define DSS_returnflag		0x03		; DSS_status Bit 3 :
#define DSS_tempbit			0x04		; DSS_status Bit 4 :
#define DSS_posnegbit		0x05

#define Bit_Halb			d'63'		; 63 : Bit-Halbe @ 1200Baud = 0,416ms = ca. 63 @ 20MHz
#define Bit_Ganz			d'129'		; 129 : Volles Bit @ 1200Baud = 0,833ms = ca. 129 @ 20MHz
	
;*************************************************************************
; Anweisung fr Bootloader - nicht ndern
;*************************************************************************

RESET_Vector:
    
	ORG     0x0000
    clrf 	PCLATH
	GOTO    INIT
	
;*************************************************************************
; Anweisung fr Interrupt Service Routine
;*************************************************************************
	
	ORG     0x0004      		; Speicherstelle 04
	
;*************************************************************************
; INIT - Erster Programmstart nach dem Reset oder Power-Up
;*************************************************************************
	
INIT:							; Test
	BANKSEL PORTA	
	CLRF 	PORTA
	BANKSEL LATA
	CLRF	LATA
	BANKSEL ANSELA
	CLRF 	ANSELA
	CLRF	ANSELB
	
	BANKSEL TRISA
	MOVLW	B'11111100' 		; Set RA<7:2> as inputs and set RA<1:0> as outputs
	MOVWF	TRISA			
	
	BANKSEL TRISB
	MOVLW	B'11111111' 		; Alle RB als Inputs
	MOVWF	TRISB			
	
	BANKSEL	DACCON0
	MOVLW	B'10100000'			;
	MOVWF	DACCON0
	
	BANKSEL	OPTION_REG			;
	BCF		OPTION_REG,TMR0CS	;
	BCF		OPTION_REG,PSA		;	
	
	BANKSEL	INTCON				;
	BCF		INTCON,TMR0IF		;
	BCF		INTCON,TMR0IE		;
	BCF		INTCON,GIE			;
	
	BANKSEL T2CON				;
	MOVLW	b'00111001'			; 
	MOVWF	T2CON				;

	CALL	Init_Ser
	
	CALL	DS_Searchparts

;*************************************************************************
; Delay_Bit_Halb - Wartet ein halbes Bit bei 1200Baud ab 
;*************************************************************************

Delay_Bit_Halb:
	MOVLB	0x00				; Bank 0
	MOVLW	Bit_Halb			; Wartezeit holen
	MOVWF	PR2					; in PR2 schreiben
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BSF		T2CON,TMR2ON		; Timer 2 Starten
Delay_Bit_Halb1:	
	BTFSS	PIR1,TMR2IF			; Zeit abgelaufen ?
	GOTO	Delay_Bit_Halb1		; nein
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BCF		T2CON,TMR2ON		; Timer 2 Stoppen
	RETURN						; zurueck

;*************************************************************************
; Delay_Bit_Ganz - Wartet ein ganzes Bit bei 1200Baud ab 
;*************************************************************************

Delay_Bit_Ganz:
	MOVLB	0x00				; Bank 0
	MOVLW	Bit_Ganz			; Wartezeit holen
	MOVWF	PR2					; in PR2 schreiben
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BSF		T2CON,TMR2ON		; Timer 2 Starten
Delay_Bit_Ganz1:	
	BTFSS	PIR1,TMR2IF			; Zeit abgelaufen ?
	GOTO	Delay_Bit_Ganz1		; nein
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BCF		T2CON,TMR2ON		; Timer 2 Stoppen
	RETURN						; zurueck

;*************************************************************************
; Delay_500us - Wartet 500us ab bei 20MHz
;*************************************************************************

Delay_500us:
	MOVLB	0x00				; Bank 0
	MOVLW	0x4D				; Wartezeit holen
	MOVWF	PR2					; in PR2 schreiben
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BSF		T2CON,TMR2ON		; Timer 2 Starten
Delay_500us1:	
	BTFSS	PIR1,TMR2IF			; Zeit abgelaufen ?
	GOTO	Delay_500us1		; nein
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BCF		T2CON,TMR2ON		; Timer 2 Stoppen
	RETURN						; zurueck

;*************************************************************************
; Delay_100us - Wartet 100us ab bei 20MHz
;*************************************************************************

Delay_100us:
	MOVLB	0x00				; Bank 0
	MOVLW	0x0F				; Wartezeit holen
	MOVWF	PR2					; in PR2 schreiben
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BSF		T2CON,TMR2ON		; Timer 2 Starten
Delay_100us1:	
	BTFSS	PIR1,TMR2IF			; Zeit abgelaufen ?
	GOTO	Delay_100us1		; nein
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BCF		T2CON,TMR2ON		; Timer 2 Stoppen
	RETURN						; zurueck

;*************************************************************************
; Delay_15us - Wartet 15us ab bei 20MHz
;*************************************************************************

Delay_15us:
	MOVLB	0x00				; Bank 0
	MOVLW	0x01				; Wartezeit holen
	MOVWF	PR2					; in PR2 schreiben
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BSF		T2CON,TMR2ON		; Timer 2 Starten
Delay_15us1:	
	BTFSS	PIR1,TMR2IF			; Zeit abgelaufen ?
	GOTO	Delay_15us1		; nein
	BCF		PIR1,TMR2IF			; Timer 2 Flag zuruecksetzen
	BCF		T2CON,TMR2ON		; Timer 2 Stoppen
	RETURN						; zurueck

;*************************************************************************
; Serielle Schnittstelle Initializieren
; 20MHz, 38400 Baud, 8n1
; BRG16=1, BRGH=1, SPBRG=129 
;*************************************************************************

Init_Ser:
	BANKSEL	SPBRGH
	MOVLW	d'129'
	MOVWF	SPBRGL
	MOVLW	d'000'
	MOVWF	SPBRGH
	BSF		BAUDCON,BRG16
	BSF		TXSTA,BRGH
	BCF		TXSTA,SYNC
	BSF		RCSTA,SPEN
	BSF		TXSTA,TXEN
	RETURN

	
TX_Ser:
	BANKSEL	TXREG
TX_Ser1:
	BTFSS	TXSTA,TRMT
	GOTO	TX_Ser1
	MOVWF	TXREG
	RETURN
	
	ORG  0x0200
	
;*************************************************************************
; DS_Init : Init des DS18S20, Carry auf 0 wenn Devices am Bus sind
;*************************************************************************

DS_Init:
	BANKSEL	PORTB
	BCF		PORTB,3
	BANKSEL	TRISB
	BCF		TRISB,3		
	CALL	Delay_500us	 
	BANKSEL	TRISB	
	BSF		TRISB,3
	CALL	Delay_100us
	BCF		STATUS,C
	BTFSC	PORTB,3
	BSF		STATUS,C
	CALL	Delay_500us
	RETURN

;*************************************************************************
; DS_TXB : Schickt ein Byte auf die Reise
;*************************************************************************

DS_TX_Byte:
	MOVWF	temp1				; Byte in buffer sichern
	MOVLW	d'8'				; 
	MOVWF	temp2
DS_TX_Byte1:
	RRF		temp1,F				; Byte rechts rotieren und Bit in C
	CALL	DS_TX_Bit
	DECFSZ	temp2,F				; Schon 8 Bits verarbeitet ?
	GOTO	DS_TX_Byte1				;
	RETURN						;

;*************************************************************************
; DS_TX_Bit : Schickt ein Bit auf die Reise, muss im Carry sein
;*************************************************************************

DS_TX_Bit:
	BTFSS	STATUS,C			;
	GOTO	DS_TX_Bit2				;
	BANKSEL	PORTB				; "1"
	BCF		PORTB,3
	BANKSEL	TRISB
	BCF		TRISB,3		
	CALL	Delay_15us	 
	BANKSEL	TRISB	
	BSF		TRISB,3
	CALL	Delay_100us
	RETURN
DS_TX_Bit2:
	BANKSEL	PORTB				; "0"
	BCF		PORTB,3
	BANKSEL	TRISB
	BCF		TRISB,3		
	CALL	Delay_100us	 
	BANKSEL	TRISB	
	BSF		TRISB,3
	CALL	Delay_15us
	RETURN				;
	
;*************************************************************************
; DS_RX_Byte : Holt ein Byte vom Sensor ab
;*************************************************************************

DS_RX_Byte:
	CLRF	temp1				; Byte in buffer sichern
	MOVLW	d'8'				; 
	MOVWF	temp2				; Zaehler
DS_RX_Byte1:
	CALL	DS_RX_Bit
	RRF		temp1,F				; Byte rechts rotieren und Bit aus C mit reinschieben
	DECFSZ	temp2,F				; Schon 8 Bits verarbeitet ?
	GOTO	DS_RX_Byte1				;
	MOVF	temp1,W				; Ergebnis in W
	RETURN						;	

;*************************************************************************
; DS_RX_Bit : Holt ein Bit vom Sensor ab und legt es ins Carry ab
;*************************************************************************

DS_RX_Bit:
	BANKSEL	PORTB				; 
	BCF		PORTB,3
	BANKSEL	TRISB
	BCF		TRISB,3		
	NOP
	NOP
	NOP;						
	NOP
	NOP
	BANKSEL	TRISB	
	BSF		TRISB,3
	CALL	Delay_15us
	BANKSEL PORTA
	BSF		PORTA,0
	BCF		PORTA,0
	BANKSEL	PORTB
	BCF		STATUS,C
	BTFSC	PORTB,3
	BSF		STATUS,C
	CALL	Delay_100us			;
	RETURN						;	

;*************************************************************************
; DS_Searchparts : Holt von jedem Temp-Sensor am Bus das Scratchpad ab und endet dann
;
; RAM fuer gefundene Nummer wird ber indirekte Adressierung (FSR und IND) angesprochen
; Reale Adresse : ab 220h die restlichen 48 Bytes
; Indirekte Adresse : ab 2140h die restlichen 48 Bytes
;*************************************************************************

DS_Searchparts:

	CALL	DS_Init
	
	MOVLW	0xCC
	CALL	DS_TX_Byte				; SKIP ROM
		
	MOVLW	0x44
	CALL	DS_TX_Byte				; CONVERT T

	MOVLW	0xFF
	MOVWF	temp3
DS_Searchparts88:	
	CALL	Delay_Bit_Ganz
	CALL	Delay_Bit_Ganz
	CALL	Delay_Bit_Ganz
	CALL	Delay_Bit_Ganz
	DECFSZ	temp3,F
	GOTO	DS_Searchparts88	
	
	CLRF	DSS_lastdiscrepancy					; Fuer FIRST Suche zurueckstellen
	BCF		DSS_status,DSS_doneflag

	MOVLW	0x40							; Offset fr 220h ... 250h
	MOVWF	FSR1L							; in High FSR1 schreiben
	MOVLW	0x21							; 2xxh Highteil
	MOVWF	FSR1H							; in High FSR1 schreiben
	CLRF	INDF1							;
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	INCF	FSR1L,F							;
	CLRF	INDF1
	
DS_Searchparts1:	

	CALL	DS_Search						; Ein Teilnehmer suchen
	
	MOVLW	0x04							; Wieviele Stellen der Teilnehmer-ID ausgeben ? (Device-Code am Anfang nicht)
	MOVWF	temp4							; 0x06 = alle Stellen, 0x03 = alle bisher ndernden stellen, zur Sicherheit 4
	
	MOVLW	0x41							; Offset fr 220h ... 250h + 1 (ID-Code nicht wichtig)
	MOVWF	FSR1L							; in High FSR1 schreiben
	MOVLW	0x21							; 2xxh Highteil
	MOVWF	FSR1H							; in High FSR1 schreiben
	
DS_SP1A:
	MOVIW	FSR1++
	CALL	Hextoascii
	MOVF	temp2,W							;
	CALL	TX_Ser
	MOVF	temp3,W
	CALL	TX_Ser
	DECFSZ	temp4,F							;
	GOTO	DS_SP1A
	
	CLRF	temp4
	CLRF	temp3
	CLRF	temp2
	CLRF	temp1
	CLRF	FSR1H
	CLRF	FSR1L
	
	
	
	MOVLW	0xBE
	CALL	DS_TX_Byte						; READ SCRATCHPAD [BEh] Kommando senden

	CALL	DS_RX_Byte						; Byte 0
	MOVWF	temp3
	CALL	DS_RX_Byte						; Byte 1
	MOVWF	temp4
	
	; Temperatur steht in Scratchpad $00 (LSB) und $01 (MSB) und $06 Count Remain
	
	BTFSC	temp4,7							; negative Temperatur ???
	GOTO    NegTempCalc

	MOVLW	'+'
	CALL	TX_Ser
	BSF		DSS_status,DSS_posnegbit

PosTempOut:
	
	BCF		STATUS,C
	RRF		temp3,W
	CALL	Bintobcd

	MOVF	temp2,W
	CALL	TX_Ser
	MOVF	temp3,W
	CALL	TX_Ser
	MOVF	temp4,W
	CALL	TX_Ser

	MOVLW	','
	CALL	TX_Ser
	
	GOTO	DS_Searchparts20
	
NegTempCalc:	

	BSF		temp3,7
	COMF	temp3,F
	
	MOVLW	'-'
	CALL	TX_Ser
	BCF		DSS_status,DSS_posnegbit
	
	GOTO	PosTempOut

DS_Searchparts20:
	
	CALL	DS_RX_Byte						; Byte 2
	CALL	DS_RX_Byte						; Byte 3
	CALL	DS_RX_Byte						; Byte 4
	CALL	DS_RX_Byte						; Byte 5
	CALL	DS_RX_Byte						; Byte 6
	
	MOVWF	temp1							; Count Remain zwischenspeichern
	DECF	temp1,F							; 1..16 zu 0..15 machen
	
	BTFSC	DSS_status,DSS_posnegbit		; Negative Zahl ? "0"
	GOTO	DS_Searchparts22
	MOVF	temp1,W
	SUBLW	0x0F							; Tabelle umdrehen 15 - W => W
	MOVWF	temp1
	
DS_Searchparts22:	
	RLF		temp1,F
	RLF		temp1,W
	ANDLW	b'00111100'
	
	MOVWF	FSR1L							; in High FSR1 schreiben
	MOVLW	0x85							; 05xxh Highteil
	MOVWF	FSR1H							; in High FSR1 schreiben
	
	MOVF	PORTB,W							; Port B einlesen
	ANDLW	b'00110000'						;
	MOVWF	temp2							; nach temp2
	RRF		temp2,F
	RRF		temp2,F
	RRF		temp2,F
	RRF		temp2,W
	ANDLW	B'00000011'
	MOVWF	temp2							; Anzahl von 0 bis 2
	INCF	temp2,F							; nun 1..4

	MOVLW	D'4'							; *** Ueberschreiben, so das immer 4 Stellen kommen
	MOVWF	temp2
	
DS_Searchparts33:	
	MOVF	INDF1,W							; 
	CALL	TX_Ser
	INCF	FSR1L,F
	
	DECFSZ	temp2,F							; schon alle Stellen ausgegeben ?
	GOTO	DS_Searchparts33
	
	MOVLW	' '
	CALL	TX_Ser
	
	BTFSS	DSS_status,DSS_doneflag			; War es das letzte Device am Bus ? 
	GOTO	DS_Searchparts1
	
	MOVLW	0x0D
	CALL	TX_Ser
	MOVLW	0x0A
	CALL	TX_Ser
	
DS_Search99:
	GOTO	DS_Searchparts						; Endlosschleife

;*************************************************************************
; Hextoascii : Wandelt Byte W in ASCII um
; Input : W, Output : temp2:higher, temp3:lower
;*************************************************************************
Hextoascii:
	MOVWF	temp1									; in temp1 zwischenspeichern
	SWAPF	temp1,W									; oberes Teil in W
	ANDLW	b'00001111'								;
	CALL	Gethexascii
	MOVWF	temp2
	MOVF	temp1,W									;
	ANDLW	b'00001111'								;
	CALL	Gethexascii
	MOVWF	temp3
	RETURN
	
Gethexascii:	
	BRW												; w enthaelt (0..15)
	RETLW  	0x30
	RETLW  	0x31
	RETLW  	0x32
	RETLW  	0x33
	RETLW  	0x34
	RETLW  	0x35
	RETLW  	0x36
	RETLW  	0x37
	RETLW  	0x38
	RETLW	0x39
	RETLW  	0x41
	RETLW  	0x42
	RETLW  	0x43
	RETLW  	0x44
	RETLW  	0x45
	RETLW  	0x46

	ORG  0x0300
;*************************************************************************
; DS_Search : Sucht nach dem naechsten Temperatursensor auf dem Bus
; #define DSS_rombitindex		0x7C		; 
; #define DSS_lastdiscrepancy	0x7D		; 
; #define DSS_status			0x7E		; 
; #define DSS_discrepancymarker 0x7F		;
; #define DSS_bita				0x00		; DSS_status Bit 0 : 
; #define DSS_bitb				0x01		; DSS_status Bit 1 :
; #define DSS_doneflag			0x02		; DSS_status Bit 2 :
; #define DSS_returnflag		0x03		; DSS_status Bit 3 :
; #define DSS_tempbit			0x04		; DSS_status Bit 4 :
;*************************************************************************
	
DS_Search:

	BCF		DSS_status,DSS_returnflag		; Returnvalue to 0
	
	BTFSC	DSS_status,DSS_doneflag
	GOTO	DS_Search0

	CALL	DS_Init

	BTFSC	STATUS,C						; Carry auf 0 = noch jemand da
	GOTO	DS_Search01
	
	CLRF	DSS_discrepancymarker					; Fuer die NEXT Suche zurueckstellen
	MOVLW	d'1'
	MOVWF	DSS_rombitindex						; Fuer die NEXT Suche zurueckstellen
	
	MOVLW	0xF0
	CALL	DS_TX_Byte						; SEARCH ROM [F0h]
		
DS_Search1:	
	CALL	DS_RX_Bit						; Ein Bit vom Bus abholen (idbit)
	BSF		DSS_status,DSS_bita
	BTFSS	STATUS,C
	BCF		DSS_status,DSS_bita
	
	CALL	DS_RX_Bit						; Ein Bit vom Bus abholen (cmpidbit)
	BSF		DSS_status,DSS_bitb
	BTFSS	STATUS,C
	BCF		DSS_status,DSS_bitb
	
	BCF		STATUS,Z
	MOVF	DSS_status,W					; Status reinholen (enthaelt beide Bits)
	ANDLW	b'00000011'						; die unteren beiden Bits ausmaskieren
	SUBLW	b'00000011'						; 
	BTFSC	STATUS,Z						; Zero nur gesetzt wenn beide gesetzt waren
	GOTO	DS_Search01						; idbit und cmpidbit = 1 => Suche beenden
	
	BCF		STATUS,Z
	MOVF	DSS_status,W					; Status reinholen (enthaelt beide Bits)
	ANDLW	b'00000011'						;
	BTFSC	STATUS,Z						; idbit und cmpidbit = 0 => Diskepanz gefunden
	GOTO	DS_Search10
		
	BSF		DSS_status,DSS_tempbit			; Umkopieren von bita zu 
	BTFSS	DSS_status,DSS_bita				;
	BCF		DSS_status,DSS_tempbit			;
	CALL	DS_Putbit
	
DS_Search11:	
	
	CALL	DS_Getbit						; Bit abholen (steht jetzt in tempbit)

	BSF		STATUS,C						; Umkopieren von searchdirection nach CARRY
	BTFSS	DSS_status,DSS_tempbit			; 
	BCF		STATUS,C						;
	
	CALL	DS_TX_Bit						; Bit auf den Bus ausgeben
	
	INCF	DSS_rombitindex,F				; Bitzaehler umEins erhoehen
	
	MOVLW	d'65'
	SUBWF	DSS_rombitindex,W				; schon 64 Bits eingelesen ?
	
	BTFSS	STATUS,Z						;
	GOTO	DS_Search1
	
	MOVF	DSS_discrepancymarker,W
	MOVWF	DSS_lastdiscrepancy			;
	
	MOVF	DSS_lastdiscrepancy,F		; in sich selber reinschreiben zum Test auf Zero
	
	BTFSC	STATUS,Z
	BSF		DSS_status,DSS_doneflag
	BSF		DSS_status,DSS_returnflag
	RETURN
	
DS_Search0:								
	BCF		DSS_status,DSS_doneflag			; alles zuruecksetzen
	RETURN

DS_Search01:
	CLRF	DSS_lastdiscrepancy				;
	RETURN

DS_Search10:
	MOVF	DSS_rombitindex,W			
	SUBWF	DSS_lastdiscrepancy,W
	BTFSS	STATUS,Z
	GOTO	DS_Search20
	BSF		DSS_status,DSS_tempbit	; Umkopieren von searchdirektion zu id_bit
	CALL	DS_Putbit
	GOTO	DS_Search11
	
DS_Search20:
	MOVF	DSS_rombitindex,W
	SUBWF	DSS_lastdiscrepancy,W
	BTFSC	STATUS,C
	GOTO	DS_Search22
	BCF		DSS_status,DSS_tempbit	;
	CALL	DS_Putbit
	MOVF	DSS_rombitindex,W
	MOVWF	DSS_discrepancymarker
	GOTO	DS_Search11

DS_Search22:
	; Bitnummer idbitnumber aus dem ROM_NO Speicher holen und in das Searchdirection speichern
	CALL	DS_Getbit
	BTFSC	DSS_status,DSS_tempbit
	GOTO	DS_Search11
	MOVF	DSS_rombitindex,W
	MOVWF	DSS_discrepancymarker	
	GOTO	DS_Search11

ORG  0x0400
		
;*************************************************************************
; DS_Putbit : Speichert ein gefundenes Bit ab
; Nummer des Bits ist in DSS_rombitindex [1..64]
; Bitinhalt ist in DSS_status,DSS_tempbit abgelegt
;*************************************************************************

DS_Putbit:
	BANKSEL	FSR1L							; Bytenummer errechnen in denen das Bit steckt
	DECF	DSS_rombitindex,W				; von 1..64 auf 0..63 reduzieren
	MOVWF	temp4							; in temp4 speichern
	RRF		temp4,F							; /2
	RRF		temp4,F							; /2
	RRF		temp4,W							; /2
	ANDLW	b'00000111'						; untere Bits maskieren
	ADDLW	0x40							; Offset fr 220h ... 250h
	MOVWF	FSR1L							; in High FSR1 schreiben
	MOVLW	0x21							; 2xxh Highteil
	MOVWF	FSR1H							; in High FSR1 schreiben
	DECF	DSS_rombitindex,W				; von 1..64 auf 0..63 reduzieren
	ANDLW	b'00000111'						; untere Bits maskieren
	MOVWF	temp4							; in temp4 speichern
	BTFSS	DSS_status,DSS_tempbit
	GOTO	DS_Putbit1
	MOVF	temp4,W							; 
	CALL	DS_Putbit_Table					; Bit zu Position wandlung	
	BANKSEL	INDF1
	IORWF	INDF1,F							; OR mit der Tabelle und dem Wert, ergo das Bit setzen
	RETURN
	
DS_Putbit1:
	MOVF	temp4,W							;
	CALL	DS_Putbit_Table					; Bit zu Position wandlung
	MOVWF	temp4							;
	COMF	temp4,W							;
	ANDWF	INDF1,F							; AND mit Komplement der Tabelle und dem Wert, ergo das Bit loeschen
	RETURN
	
DS_Putbit_Table:	
	BRW										; w enthaelt (0..7)
	RETLW  	b'00000001'
	RETLW  	b'00000010'
	RETLW  	b'00000100'
	RETLW  	b'00001000'
	RETLW  	b'00010000'
	RETLW  	b'00100000'
	RETLW  	b'01000000'
	RETLW  	b'10000000'
	
;*************************************************************************
; DS_Getbit : Holt ein gewnschtes Bit ab und legt es in searchdirection ab
; Nummer des Bits ist in DSS_rombitindex [1..64]
; Bitinhalt ist in DSS_status,DSS_tempbit abgelegt
;*************************************************************************

DS_Getbit:
	BANKSEL	FSR1L							; Bytenummer errechnen in denen das Bit steckt
	DECF	DSS_rombitindex,W				; von 1..64 auf 0..63 reduzieren
	MOVWF	temp4							; in temp4 speichern
	RRF		temp4,F							; /2
	RRF		temp4,F							; /2
	RRF		temp4,W							; /2
	ANDLW	b'00000111'						; untere Bits maskieren
	ADDLW	0x40							; Offset fr 220h ... 250h
	MOVWF	FSR1L							; in High FSR1 schreiben
	MOVLW	0x21							; 2xxh Highteil
	MOVWF	FSR1H							; in High FSR1 schreiben
	
	DECF	DSS_rombitindex,W				; von 1..64 auf 0..63 reduzieren
	ANDLW	b'00000111'						; untere Bits maskieren
	CALL	DS_Getbit_Table					; Bit zu Position wandlung
	ANDWF	INDF1,W							; AND mit der Tabelle und dem Wert, ergo das Bit pruefen ob ZERO oder nicht
	BTFSS	STATUS,Z						; 0 dann wars ne 0
	GOTO	DS_Getbit1						;
	BCF		DSS_status,DSS_tempbit				;
	RETURN

DS_Getbit1:
	BSF		DSS_status,DSS_tempbit				;
	RETURN
	
DS_Getbit_Table:	
	BRW										; w enthaelt (0..7)
	RETLW  	b'00000001'
	RETLW  	b'00000010'
	RETLW  	b'00000100'
	RETLW  	b'00001000'
	RETLW  	b'00010000'
	RETLW  	b'00100000'
	RETLW  	b'01000000'
	RETLW  	b'10000000'

;*************************************************************************
; Bintobcd : Wandelt Byte W in ASCII um
; Input : W, Output : temp2:hunderter, temp3:zehner, temp4:einer
; braucht Num_Bytes als Zwischenspeicher !
; ADD3 Algorithm
;*************************************************************************

Bintobcd:
	MOVWF	temp1							; Zahl in temp1 zwischenspeichern
	MOVLW	d'8'
	MOVWF	num_bytes						; Zaehler
	CLRF	temp2							; Hunderter
	CLRF	temp3							; Zehner
	CLRF	temp4							; Einer

Bintobcd01:
	MOVLW	d'5'
	SUBWF	temp2,W
	BTFSC	STATUS, C
	CALL 	Bintobcdadd100

	MOVLW	d'5'
	SUBWF	temp3,W
	BTFSC	STATUS, C
	CALL 	Bintobcdadd10

	MOVLW	d'5'
	SUBWF	temp4,W
	BTFSC	STATUS, C
	CALL 	Bintobcdadd1

	DECF	num_bytes, F
	BCF		STATUS, C
	RLF		temp1,F
	RLF		temp4,F
	BTFSC	temp4,4 
	CALL 	Bintobcdc1
	RLF		temp3,F

	BTFSC	temp3,4 ; 
	CALL 	Bintobcdc10
	RLF		temp2,F
	BCF 	STATUS, C

	MOVF	num_bytes,W
	BTFSS	STATUS, Z
	GOTO 	Bintobcd01

	MOVF 	temp2,W
	ADDLW	h'30'
	MOVWF	temp2

	MOVF 	temp3,W
	ADDLW	h'30'
	MOVWF	temp3

	MOVF 	temp4,W	
	ADDLW	h'30'
	MOVWF	temp4

	RETURN

Bintobcdadd100:
	MOVLW	d'3'
	ADDWF	temp2,F
	RETURN

Bintobcdadd10:
	MOVLW	d'3'
	ADDWF	temp3,F
	RETURN

Bintobcdadd1:
	MOVLW	d'3'
	ADDWF	temp4,F
	RETURN

Bintobcdc1:
	BCF		temp4, 4
	BSF		STATUS, C
	RETURN

Bintobcdc10:
	BCF		temp3, 4
	BSF 	STATUS, C
	RETURN

;*************************************************************************
; Tabellen fuer Nachkommastellenberechnung
;*************************************************************************
	
Table4Dig:										; von 0..15, aber aus Count-Remain kommt 1..16 raus, fuer negative Zahlen Reihenfolge umdrehen
	ORG	0x0500
	DE "9375"
	DE "8750"
	DE "8125"
	DE "7500"
	DE "6875"
	DE "6250"
	DE "5625"
	DE "5000"
	DE "4375"
	DE "3750"
	DE "3125"
	DE "2500"
	DE "1875"
	DE "1250"
	DE "0625"
	DE "0000"

Table3Dig:
	ORG	0x0540	
	DE "9380"
	DE "8750"
	DE "8130"
	DE "7500"
	DE "6880"
	DE "6250"
	DE "5630"
	DE "5000"
	DE "4380"
	DE "3750"
	DE "3130"
	DE "2500"
	DE "1880"
	DE "1250"
	DE "0630"
	DE "0000"
	
Table2Dig:
	ORG	0x0580	
	DE "9400"
	DE "8800"
	DE "8100"
	DE "7500"
	DE "6900"
	DE "6300"
	DE "5600"
	DE "5000"
	DE "4400"
	DE "3800"
	DE "3100"
	DE "2500"
	DE "1900"
	DE "1300"
	DE "0600"
	DE "0000"	
	
Table1Dig:
	ORG	0x05C0	
	DE "9000"
	DE "9000"
	DE "8000"
	DE "8000"
	DE "7000"
	DE "6000"
	DE "6000"
	DE "5000"
	DE "4000"
	DE "4000"
	DE "3000"
	DE "3000"
	DE "2000"
	DE "1000"
	DE "1000"
	DE "0000"

	
DATAEE    ORG  0xF000


END




