	list n=78, p=PIC16C84, r=HEX
	TITLE "RCTC-Decoder"

;*************************************************************************
;
;             PIC 16C84 - RCTC-Decoder .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 17.07.1999
;  Status    : A1.0                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE disabled
;
;  Comments  : -an die 4 Speicherbaenke denken !!!!
;              -Hex: 000-0FF, 100-1FF, 200-2FF, 300-3FF
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 |  Out | Displayselektor 74LS42 - A (Pin15)
; | Port A RA1 Pin 18 |  Out | Displayselektor 74LS42 - B (Pin14)
; | Port A RA2 Pin 01 |  Out | Displayselektor 74LS42 - C (Pin13)
; | Port A RA3 Pin 02 | In   | Eingang fuer RCTC-Timecode
; |                   |      |
; | Port B RB0 Pin  6 |  Out | Datenbus 74LS374 D0 Segment 4
; | Port B RB1 Pin  7 |  Out | Datenbus 74LS374 D1 Segment 3
; | Port B RB2 Pin  8 |  Out | Datenbus 74LS374 D2 Segment 2
; | Port B RB3 Pin  9 |  Out | Datenbus 74LS374 D3 Segment 1
; | Port B RB4 Pin 10 |  Out | Datenbus 74LS374 D4 Segment 8
; | Port B RB5 Pin 11 |  Out | Datenbus 74LS374 D5 Segment 7
; | Port B RB6 Pin 12 |  Out | Datenbus 74LS374 D6 Segment 6
; | Port B RB7 Pin 13 |  Out | Datenbus 74LS374 D7 Segment 5
;
; Display-Segmente:      Zahl:  8765 4321 : -> St.byte:  /St.byte:
;        3                 0    0111 1101      1110 1011   "14"     
;       ---                1    0100 1000      0010 0001   "DE"     
;    1!     !4             2    0011 1110      1100 0111   "38"    
;     !  2  !              3    0110 1110      0110 0111   "98"    
;       ---                4    0100 1011      0010 1101   "D2"    
;    5!     !7             5    0110 0111      0110 1110   "91"    
;     !  6  !              6    0111 0111      1110 1110   "11"    
;       ---                7    0100 1100      0010 0011   "DC"    
;           *8             8    0111 1111      1110 1111   "10"    
;                          9    0110 1111      0110 1111   "90"    
;                          -    0000 0010      0000 0100   "F6"    
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; Bitdauer     40H =  64 Zyklen fuer 104 us/260 Zyklen
; HalbBitdauer 20H =  32 Zyklen fuer 52 us/130 Zyklen
;
; Datenauswertung : 8 Bytes einlesen
;
; Byte 0..3 wegschmeissen
; Byte 4 : X1 Eject, X2 Stop; X3 FF/Rwd; X4 Record, X6 Play; X7 Slow/Still
;
; Byte 5 : 3X dann Bytes 6 und 7 Sekunden und Minuten
;          4X dann Bytes 6 und 7 Stunden
;
; Byte 6 : Oberes Nibble Sekunden Zehner / Stunden Zehner
;          Unteres Nibble Sekunden Einer / Stunden Einer
;
; Byte 7 : Oberes Nibble Minuten Zehner / Frame-Counter Zehner ?
;          Unteres Nibble Minuten Einer / Frame-Counter Einer  ?
;
;*************************************************************************

; Paar Flags definieren

RP1     EQU     6       ; Bank Flag im Status-Register
RP0     EQU     5       ; Bank Flag im Status-Register                                                       
RD      EQU     0       ; Start-Lesen im EECON1-Register
CARRY   EQU     0       ; Carry-Flag im Status-Register
ZER     EQU     2       ; Zero-Flag im Status-Register

;Definieren der RAM's
;00 bis 0Bh sind fest zugeordneter Systemspeicher

RTCC            EQU     1       ; RTCC
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08     ; EEPROM Data Register
EEADR           EQU     09     ; EEPROM Adress Register
EECON1          EQU     08     ; EEPROM Control Register 1
EECON2          EQU     09     ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

BYTECNT         EQU     0CH     ; Zaehler um 8 Byte zu holen
BITCNT          EQU     0DH     ; Zaehler um 8 Bit zu holen       
INBU0           EQU     0EH     ; Input Buffer Byte 0
INBU1           EQU     0FH     ; Input Buffer Byte 1
INBU2           EQU     10H     ; Input Buffer Byte 2
INBU3           EQU     11H     ; Input Buffer Byte 3                                  
INBU4           EQU     12H     ; Input Buffer Byte 4                                 
INBU5           EQU     13H     ; Input Buffer Byte 5                                  
INBU6           EQU     14H     ; Input Buffer Byte 6                                   
INBU7           EQU     15H     ; Input Buffer Byte 7      
TMPA            EQU     16H     ; Zur
TMPB            EQU     17H     ;     freien
TMPC            EQU     18H     ;            Verfuegung
TMPD            EQU     19H     ;                      !         
DIGI0           EQU     1AH     ; Anzeige Buffer Byte 0
DIGI1           EQU     1BH     ; Anzeige Buffer Byte 1
DIGI2           EQU     1CH     ; Anzeige Buffer Byte 2
DIGI3           EQU     1DH     ; Anzeige Buffer Byte 3                                  
DIGI4           EQU     1EH     ; Anzeige Buffer Byte 4                                 
DIGI5           EQU     1FH     ; Anzeige Buffer Byte 5                                  
DIGI6           EQU     20H     ; Anzeige Buffer Byte 6                                   
DIGI7           EQU     21H     ; Anzeige Buffer Byte 7      

;*************************************************************************
	
	ORG     0x000           ; Speicherseite 00
	GOTO    RESVEK          ; Reset-Vektor

RESVEK  MOVLW   B'11111000'     ; RA0..RA2 Ausgang
	TRIS    PORT_A          ; RA3 Eingang

	MOVLW   B'00000000'     ; RB0..RB7 Ausgang
	TRIS    PORT_B          ;

	CLRWDT                  ; Watchdog Timer zuruecksetzen
	MOVLW   B'00000000'     ; kein Vorteiler
	OPTION                  ;

	MOVLW   B'00000000'     ; RTCC-INT disable
	MOVWF   INTCON          ;

;*************************************************************************

; Alle Variablen loeschen

START   CLRF    BYTECNT         ; Byte-Zaehler auf 0
	CLRF    BITCNT          ; Bit-Zaehler auf 0
	CLRF    TMPA            ;
	CLRF    TMPB            ;
	CLRF    TMPC            ;
	CLRF    TMPD            ;
	CLRF    DIGI0           ;
	CLRF    DIGI1           ;
	CLRF    DIGI2           ;
	CLRF    DIGI3           ;
	CLRF    DIGI4           ;
	CLRF    DIGI5           ;
	CLRF    DIGI6           ;
	CLRF    DIGI7           ;
	CALL    DISPL           ; Leeres Display darstellen

;*************************************************************************
; Start-Byte 0 kommt, wenn mind. 12x104us kein 0-Bit kam
; Innere Schleife: 2+ ((2+1+2)*TMPB)+2
; Aeussere Schleife: 2+ ((Innen+1+2)*TMPA)+2
; Ges.= 4+(((5*TMPB)+7)*TMPA) Zyklen

SEARCH  MOVLW   0CH             ; 12x aussen ausfuehren
	MOVWF   TMPA            ; nach TMPA
LOOPA   MOVLW   28H             ; 40x innen ausfuehren
	MOVWF   TMPB            ; nach TMPB
LOOPB   BTFSS   PORT_A,3        ; ist Timecode-Leitung 1 ?
	GOTO    SEARCH          ; eine Null trat auf, zurueck zum Anfang
	DECFSZ  TMPB,1          ; eins weg ...
	GOTO    LOOPB           ; zurueck innere Schleife
	DECFSZ  TMPA,1          ; eins weg ...
	GOTO    LOOPA           ; zurueck zur aeusseren Schleife

; 8 Bytes vom Port abholen

GETRCTC CALL    GETBIT          ; 0. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU0           ;
	CALL    GETBIT          ; 1. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU1           ;
	CALL    GETBIT          ; 2. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU2           ;
	CALL    GETBIT          ; 3. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU3           ;
	CALL    GETBIT          ; 4. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU4           ;
	CALL    GETBIT          ; 5. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU5           ;
	CALL    GETBIT          ; 6. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU6           ;
	CALL    GETBIT          ; 7. Byte holen
	MOVF    TMPD,0          ;
	MOVWF   INBU7           ;

; die 8 Bytes verarbeiten

	MOVF    INBU5,0         ; Byte 5 nach W
	ANDLW   0F0H            ; oberen Bits leben lassen
	MOVWF   INBU5           ; wieder zurueckschreiben
	SWAPF   INBU5,1         ; Bits vertauschen
	MOVLW   003H            ; 
	SUBWF   INBU5,0         ; Byte 5 auf 3X ?
	BTFSC   STATUS,ZER      ; 
	GOTO    SEKMIN          ; Sekunden und Minuten abholen
	MOVLW   004H            ; Byte 5 auf 4X ?   
	SUBWF   INBU5,0         ;
	BTFSC   STATUS,ZER      ;
	GOTO    STUFRA          ; Stunden und Frames
	GOTO    SEARCH          ; wenig erfolgreich ...

; Routine zum Verarbeiten von Sekunden und Minuten

SEKMIN  MOVF    INBU6,0         ; Byte 6 holen
	ANDLW   0F0H            ; oben maskieren
	MOVWF   TMPA            ; nach TMPA
	SWAPF   TMPA,0          ; Bits vertauschen
	MOVWF   DIGI4           ; nach Sekunden Zehner
	MOVF    INBU6,0         ; Byte 6 holen
	ANDLW   00FH            ; unten maskieren
	MOVWF   DIGI5           ; nach Sekunden Einer

	MOVF    INBU7,0         ; Byte 7 holen
	ANDLW   0F0H            ; oben maskieren
	MOVWF   TMPA            ; nach TMPA
	SWAPF   TMPA,0          ; Bits vertauschen
	MOVWF   DIGI2           ; nach Minuten Zehner
	MOVF    INBU7,0         ; Byte 7 holen
	ANDLW   00FH            ; unten maskieren
	MOVWF   DIGI3           ; nach Minuten Einer

	CALL    DISPL           ; Darstellen

	GOTO    SEARCH          ; neue Bytes holen

; Routine zum Verarbeiten von Stunden und Frames

STUFRA  MOVF    INBU6,0         ; Byte 6 holen
	ANDLW   0F0H            ; oben maskieren
	MOVWF   TMPA            ; nach TMPA
	SWAPF   TMPA,0          ; Bits vertauschen
	MOVWF   DIGI0           ; nach Stunden Zehner
	MOVF    INBU6,0         ; Byte 6 holen
	ANDLW   00FH            ; unten maskieren
	MOVWF   DIGI1           ; nach Stunden Einer

	MOVF    INBU7,0         ; Byte 7 holen
	ANDLW   0F0H            ; oben maskieren
	MOVWF   TMPA            ; nach TMPA
	SWAPF   TMPA,0          ; Bits vertauschen
	MOVWF   DIGI6           ; nach Frames Zehner
	MOVLW   004H            ;
	SUBWF   DIGI6,1         ; 40H abziehen, da Zahlen von 40..64H laufen
	MOVF    INBU7,0         ; Byte 7 holen
	ANDLW   00FH            ; unten maskieren
	MOVWF   DIGI7           ; nach Frames Zehner

	CALL    DISPL           ; Darstellen

	GOTO    SEARCH          ; neue Bytes holen

;*************************************************************************
; Display Routine
; stellt die Zahlen von 00..09H und 10H (-) auf dem Display dar
; Eingabe: DIGI0..DIGI7 und INBU4

DISPL   MOVLW   B'00000000'     ; Display 7 aktivieren
	MOVWF   PORT_A          ; 
	CALL    GETSTA          ; Status holen
	MOVWF   TMPD            ; und in TMPD speichern

	MOVF    DIGI0,0         ; Wert fuer Display 0
	CALL    UMCOD           ; umkodieren
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,0          ; Bit 0 gesetzt ?
	GOTO    WEITA0          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA0  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ; W nach Port B
	MOVLW   B'00000001'     ; Display aktivieren mit 0 nach 1
	MOVWF   PORT_A          ;

	MOVF    DIGI1,0         ; Wert fuer Display 1
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,1          ; Bit 1 gesetzt ?
	GOTO    WEITA1          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA1  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000010'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI2,0         ; Wert fuer Display 2
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,2          ; Bit 2 gesetzt ?
	GOTO    WEITA2          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA2  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000011'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI3,0         ; Wert fuer Display 3
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,3          ; Bit 3 gesetzt ?
	GOTO    WEITA3          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA3  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000100'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI4,0         ; Wert fuer Display 4
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,4          ; Bit 4 gesetzt ?
	GOTO    WEITA4          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA4  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000101'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI5,0         ; Wert fuer Display 5
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,5          ; Bit 5 gesetzt ?
	GOTO    WEITA5          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA5  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000110'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI6,0         ; Wert fuer Display 6
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,6          ; Bit 6 gesetzt ?
	GOTO    WEITA6          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA6  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000111'     ; Display aktivieren
	MOVWF   PORT_A          ;

	MOVF    DIGI7,0         ; Wert fuer Display 7
	CALL    UMCOD           ;
	MOVWF   TMPC            ; nach TMPC
	BTFSS   TMPD,7          ; Bit 7 gesetzt ?
	GOTO    WEITA7          ; ohne Punkt weitermachen
	BCF     TMPC,4          ; Punkt leuchten lassen
WEITA7  MOVF    TMPC,0          ; TMPC nach W
	MOVWF   PORT_B          ;
	MOVLW   B'00000000'     ; Display aktivieren
	MOVWF   PORT_A          ;

	RETURN                  ; und wieder zurueck
	   
; Aus INBU4 die Status-Infos holen

GETSTA  MOVLW   007H            ; 
	ANDWF   INBU4,1         ; unteren 4 Bits leben lassen
	MOVF    INBU4,0         ;
	ADDWF   PC,1            ; Zum Prog Counter W dazu
	RETLW   001H            ; 0  -
	RETLW   002H            ; 1  Eject
	RETLW   004H            ; 2  Stop
	RETLW   008H            ; 3  Forward 
	RETLW   010H            ; 4  Record
	RETLW   020H            ; 5  -
	RETLW   040H            ; 6  Playback
	RETLW   080H            ; 7  Slow
	RETURN                  ;

; Zeichen fuer 7 Segment umkodieren

UMCOD   ADDWF   PC,1            ; Zum Prog Counter W dazu
	RETLW   014H            ; Code fuer 0
	RETLW   0DEH            ;          1
	RETLW   038H            ;          2
	RETLW   098H            ;          3
	RETLW   0D2H            ;          4
	RETLW   091H            ;          5
	RETLW   011H            ;          6
	RETLW   0DCH            ; Code fuer 7
	RETLW   010H            ; Code fuer 8
	RETLW   090H            ; Code fuer 9
	RETLW   0F6H            ; Code fuer -

;*************************************************************************
; Routine holt 8 Bit vom Port_A ab, und legt das Ergebnis-Byte in
; TMPD ab
;

GETBIT  BTFSC   PORT_A,3       ; kommt die erste Null ?
	GOTO    GETBIT           ; nochmal probieren
	CALL    DELAYH          ; eine halbe Bitdauer warten

	BTFSC   PORT_A,3        ; Startbit ok - noch da ?
	GOTO    SEARCH          ; nochmal alles von vorn...

	MOVLW   08H             ; 8 Bits holen
	MOVWF   BITCNT          ; nach Bitcnt
	CLRF    TMPD            ; Empfangsbyte loeschen

RXBT    CALL    DELAYF          ; ein Bit abwarten
	BTFSC   PORT_A,3        ; Status des Bits
	GOTO    ISHI            ; 1 Bit
	BSF     STATUS,CARRY    ; 0 Bit
	GOTO    ROTAT           ; weitermachen beim Bit-Rotieren

ISHI    BCF     STATUS,CARRY    ; Carry auf 1 setzen
ROTAT   RRF     TMPD            ; per Carry ein Bit ins TMPD holen
	DECFSZ  BITCNT,1        ; eins weg...
	GOTO    RXBT            ; naechstes Bit holen

	; CALL    DELAYF          ; Bitdauer wegen Stoppbit abwarten

	RETURN                  ; zurueck zur aufrufenden Routine

; Eine Zeitdauer von einem Bit warten 104 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen

DELAYF  MOVLW   040H            ; Bitdelay nach W
	MOVWF   TMPA            ; nach TMPA
LOOP1   NOP                     ; nix tun
	DECFSZ  TMPA,1          ; eins weg ...
	GOTO    LOOP1           ; noch groesser Null
	RETURN

; Eine Zeitdauer von einem halben Bit warten 52 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen

DELAYH  MOVLW   020H            ; HalfBitDelay nach W
	MOVWF   TMPA            ; nach TMPA
LOOP2   NOP                     ; nix tun
	DECFSZ  TMPA,1          ; eins weg ...
	GOTO    LOOP2           ; noch groesser Null
	RETURN

;*************************************************************************

	END                     ; das wars dann
