;*************************************************************************
;
;             PIC 16F84 - Steuerung PLL-IC TSA5522 .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 23.02.2001
;  Status    : A1.2                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE enabled
;
;  Comments  : 1. An die 4 Speicherbaenke denken !!!!
;                 -Hex: 000-0FF, 100-1FF, 200-2FF, 300-3FF
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 | In   | UP-Taster  (aktiv Low)
; | Port A RA1 Pin 18 | In   | DOWN-Taster (aktiv Low)
; | Port A RA2 Pin 01 | In   | -
; | Port A RA3 Pin 02 | In   | -
; | Port A RA4 Pin 03 | In   | n.c. 
; |                   |      |
; | Port B RB0 Pin  6 | Bi   | SDA
; | Port B RB1 Pin  7 |  Out | SCL
; | Port B RB2 Pin  8 | In   | -
; | Port B RB3 Pin  9 | In   | -
; | Port B RB4 Pin 10 | In   | -
; | Port B RB5 Pin 11 | In   | -
; | Port B RB6 Pin 12 | In   | -
; | Port B RB7 Pin 13 | In   | -
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; History: - Da Wired-OR-Bus, SDA zwischen Ein und Ausgang umschalten
;          - Beim CALL die RP0,RP1 Bits setzen !
;          - UP/Down-Tasten
;          - Tasten entprellen
;*************************************************************************

	LIST    p=16F84  ; Prozessor definieren
        __config H'3FF1' ; Fuses definieren WDT off PWRT on CP off XT on

; Register Seite 1 definieren, da OPTION- und TRIS-Befehl abgekuendigt
; RTRIS : Bit auf 1=Eingang, 0=Ausgang

ROPTION EQU     1       ; Options-Register
RTRISA  EQU     5       ; Ein/Ausgaenge Port A
RTRISB  EQU     6       ; Ein/Ausgaenge Port B

; Paar Flags definieren

RP1     EQU     6       ; Bank Flag im Status-Register
RP0     EQU     5       ; Bank Flag im Status-Register                                                       
RD      EQU     0       ; Start-Lesen im EECON1-Register
CARRY   EQU     0       ; Carry-Flag im Status-Register
ZER     EQU     2       ; Zero-Flag im Status-Register

; Definieren der RAM's
; 00 bis 0Bh sind fest zugeordneter Systemspeicher

RTCC            EQU     1       ; RTCC
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08      ; EEPROM Data Register
EEADR           EQU     09      ; EEPROM Adress Register
EECON1          EQU     08      ; EEPROM Control Register 1
EECON2          EQU     09      ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

TMPA            EQU     0CH     ; Temp-Merker
TMPB            EQU     0DH     ; Temp-Merker       
TMPC            EQU     0EH     ; Temp-Merker
TMPD            EQU     0FH     ; Temp-Merker
SENDNR          EQU     10H     ; Sender Nummer
DIVB1           EQU     11H     ; DividerByte1
DIVB2           EQU     12H     ; Dividerbyte2
BANDS           EQU     13H     ; Bandselektion
CNT             EQU     14H     ; Zaehler
MAXSEND         EQU     15H     ; Anzahl der Sender in der Tabelle

;*************************************************************************
	
	ORG     0x000           ; Speicherstelle 00
	GOTO    RESVEK          ; Reset-Vektor

RESVEK  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	MOVLW   B'11111111'     ; RA3-RA0 Eingang
	MOVWF   RTRISA          ; 
        MOVLW   B'11111100'     ; RB0/RB1 Ausgang, RB2-RB7 Eingang
	MOVWF   RTRISB          ; 
	MOVLW   B'00111000'     ; kein Vorteiler, Falling Edge und
	MOVWF   ROPTION         ; Counter-Mode
	BCF     STATUS,RP0      ; Bank 0 auswaehlen
	CLRWDT                  ; Watchdog Timer zuruecksetzen
	MOVLW   B'00000000'     ; RTCC-INT disable
	MOVWF   INTCON          ;
	
	CLRW                    ; W loeschen
	MOVWF   PORT_A          ; Port A loeschen
	MOVWF   PORT_B          ; Port B loeschen
        MOVLW   D'00'           ; SenderNr nach dem Einschalten 
	MOVWF   SENDNR          ; 
	MOVLW   D'34'           ; Anzahl der Sender in der Tabelle
	MOVWF   MAXSEND         ;

;*************************************************************************
; START - Starteinstellungen
;*************************************************************************

START   CLRW                    ; W loeschen
	BSF     RTRISB,0        ; SDA auf Eingang
	BSF     RTRISB,1        ; SCL auf Eingang
	BSF     PORT_B,0        ; Outputregister SDA auf 1
	BSF     PORT_B,1        ; Outputregister SCL auf 1 

ST1C    CALL    WAIT100         ;
        CALL    WAIT100         ;
        CALL    SENDC           ; ersten Sender einstellen

ST1     BTFSS   PORT_A,0        ; UP auf Low?
	GOTO    STUP            ; weiter bei UP
	BTFSS   PORT_A,1        ; DOWN auf Low ?
	GOTO    STDWN           ; weiter bei DOWN
        CALL    WAIT100         ; bissle warten
	GOTO    ST1             ; nochmal warten

STUP    CALL    WAIT100         ; bissle warten
        BTFSS   PORT_A,0        ; UP auf High ?
	GOTO    STUP2           ; Sendernummer erhoehen
        CALL    WAIT100         ; bissle warten
	GOTO    STUP            ; nochmal nachschauen

STDWN   CALL    WAIT100         ; bissle warten
        BTFSS   PORT_A,1        ; DOWN auf High ?
	GOTO    STDWN2          ; Sendernummer verkleinern
        CALL    WAIT100         ; bissle warten
	GOTO    STDWN           ; nochmal nachschauen
	
STUP2   INCF    SENDNR,1        ; Sendernummer+1
	MOVF    MAXSEND,0       ; letzte Sendernummer nach W
	BCF     STATUS,CARRY    ;
	SUBWF   SENDNR,0        ; W=SENDNR-MAXSEND
	BTFSS   STATUS,CARRY    ; Ueberlauf ? 
	GOTO    ST1C            ;
	CLRF    SENDNR          ; Sendernummer auf 0
	GOTO    ST1C            ;

STDWN2  BCF     STATUS,ZER      ;
        MOVF    SENDNR,0        ;   
        BTFSS   STATUS,ZER      ; Sendernummer auf 0 ? 
        GOTO    STDWN3          ;
        DECF    MAXSEND,0       ; Maxsend-1 in W
	MOVWF   SENDNR          ; Sendernummer auf Maxsend
	GOTO    ST1C            ;
STDWN3  DECF    SENDNR,1        ; Sendernummer-1
        GOTO    ST1C            ;

;*************************************************************************
; SENDC - Sendet das Kommando zum Frequenzeinstellen ab
;*************************************************************************

SENDC   GOTO    GETDB           ; aus Tabelle holen
SENDCR  MOVWF   BANDS           ; Bandselektion
	MOVF    TMPA,0          ; TMPA nach W
	MOVWF   DIVB1           ; Divider-Byte1
	MOVF    TMPB,0          ; TMPB nach W
	MOVWF   DIVB2           ; Divider-Byte2
	
	CALL    CRSTART         ; Startbedingung erzeugen
	
	MOVLW   B'11000000'     ; Erstes Byte
	CALL    SENDB           ; wegschicken
	MOVF    DIVB1,0         ; Divider Byte 1   
	CALL    SENDB           ; wegschicken
	MOVF    DIVB2,0         ; Divider Byte 2
	CALL    SENDB           ; wegschicken
	MOVLW   B'11001110'     ; Viertes Byte
	CALL    SENDB           ; wegschicken
	MOVF    BANDS,0         ; Bandselektion
	CALL    SENDB           ; wegschicken
	
	CALL    CRSTOP          ; Stopbedingung erzeugen
	
	RETURN                  ; und nochmal von vorne

;*************************************************************************
; SENDB - Sendet 8 Bit
;*************************************************************************

SENDB   MOVWF   TMPD            ; Sendebyte retten
	MOVLW   08H             ; 8 Bits schreiben
	MOVWF   TMPC            ; nach TMPC
	
TXBT    CALL    WAIT10          ; bissle warten
	BCF     STATUS,CARRY    ; Carry loeschen
	RLF     TMPD,1          ; Bit holen
	BTFSC   STATUS,CARRY    ; Status des Bits
	GOTO    ISHI            ; 1 Bit senden

	BCF     PORT_B,1        ; SCL-Bit auf 0
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	BCF     PORT_B,0        ; SDA-Bit auf 0
	BCF     RTRISB,0        ; SDA auf Ausgang schalten
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	CALL    WAIT10          ; bissle warten
	BCF     PORT_B,1        ; SCL-Bit auf 0
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	GOTO    TXW             ; weiter

ISHI    BCF     PORT_B,1        ; SCL-Bit auf 0
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	BSF     PORT_B,0        ; SDA-Bit auf 1
	BSF     RTRISB,0        ; SDA auf Eingang schalten
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	CALL    WAIT10          ; bissle warten
	BCF     PORT_B,1        ; SCL-Bit auf 0
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	GOTO    TXW             ; weiter

TXW     DECFSZ  TMPC,1          ; eins weg...
	GOTO    TXBT            ; naechstes Bit abholen

	CALL    WAIT10          ; Bitdauer wegen Stoppbit abwarten
	
	; 1 senden fuer Acknowledge
	
	BCF     PORT_B,1        ; SCL-Bit auf 0
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	BSF     RTRISB,0        ; SDA auf Eingang schalten
	BSF     PORT_B,0        ; SDA-Bit auf 1
	BSF     PORT_B,1        ; SCL-Bit auf 1
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	CALL    WAIT10          ; bissle warten
	BCF     RTRISB,1        ; SCL auf Ausgang schalten
	BCF     PORT_B,1        ; SCL-Bit auf 0
	RETURN                  ; zurueck zur aufrufenden Routine
	
;*************************************************************************
; CRSTART - Startbedingung fuer I2C-Bus erzeugen
;*************************************************************************

CRSTART BSF     PORT_B,0        ; SDA-Bit auf 1
	BSF     RTRISB,0        ; SDA auf Eingang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	CALL    WAIT10          ; bissle Warten
	BCF     PORT_B,0        ; SDA-Bit auf 0
	BCF     RTRISB,0        ; SDA auf Ausgang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	CALL    WAIT10          ; bissle Warten
	RETURN                  ; zurueck

;*************************************************************************
; CRSTOP - Stopbedingung fuer I2C-Bus erzeugen
;*************************************************************************

CRSTOP  BCF     PORT_B,0        ; SDA-Bit auf 0
	BCF     RTRISB,0        ; SDA auf Ausgang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	CALL    WAIT10          ; bissle Warten
	BSF     PORT_B,0        ; SDA-Bit auf 1
	BSF     RTRISB,0        ; SDA auf Eingang schalten
	BSF     PORT_B,1        ; SCL-Bit auf 1
	BSF     RTRISB,1        ; SCL auf Eingang schalten
	CALL    WAIT10          ; bissle Warten
	RETURN                  ; zurueck

;*************************************************************************
; WAIT100 - Warten wegen Tastenprellen
;*************************************************************************

WAIT100 MOVLW   D'255'          ;
	MOVWF   TMPA            ;
W100    CALL    WAIT10          ;
	DECFSZ  TMPA,1          ;
        GOTO    W100            ;
        RETURN                  ;

;*************************************************************************
; WAIT10 - Warten fuer I2C-Bus
;*************************************************************************

WAIT10  MOVLW   D'255'          ; 255 nach W 
	MOVWF   CNT             ; W nach CNT
WAIT11  DECFSZ  CNT,1           ; CNT dekrementieren
	GOTO    WAIT11          ; nochmal
	RETURN                  ; zurueck

;*************************************************************************
; GETDB - Holt 2 DividerBytes aus einer Tabelle ab
;         Input:  SENDNR von 0..8
;         Output: TMPA=DB1, TMPB=DB2, Bandselektion=W
;         Bandumschaltung:
;         VHF Low  : 48,25 MHz ... 140,25 MHz   (BS:00000010)
;         VHF High : 147,25 MHz ... 463,25 MHz  (BS:00000100)
;         UHF      : 471,25 MHz ... 855,25 MHz  (BS:00000001)
;         Umschaltung bei 144 MHz bzw. 467 MHz
;*************************************************************************
 
	ORG     0x200           ; Speicherstelle 100

GETDB   CLRW                    ; W loeschen
	MOVF    SENDNR,0        ; Sendernummer nach W
	MOVWF   TMPA            ; und wieder nach TMPA
	ADDWF   TMPA,1          ; TMPA+TMPA
	ADDWF   TMPA,1          ; TMPA+TMPA+TMPA
	BCF     STATUS,CARRY    ; Carry loeschen
	RLF     TMPA,1          ; TMPA*2
	BCF     TMPA,0          ; unterstes Bit loeschen
	MOVLW   HIGH TABLE      ; oberen Adressbits holen
	MOVWF   PCLATH          ; in PCLATH speichern fuer Addition
	MOVF    TMPA,0          ; Sendernummer*6 nach W
	ADDWF   PC,1            ; zum Programmcounter dazuzaehlen

	;  0 DB1=005, DB2=114 : 48,25 MHz = tm3
TABLE   MOVLW   D'005'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'114'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  1 DB1=005, DB2=226 : 55,25 MHz = SuperRTL
	MOVLW   D'005'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'226'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  2 DB1=006, DB2=082 : 62,25 MHz = Hessen
	MOVLW   D'006'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'082'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  3 DB1=010, DB2=082 : 126,25 MHz = Premiere
	MOVLW   D'010'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'082'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  4 DB1=010, DB2=194 : 133,25 MHz = TRTint
	MOVLW   D'010'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'194'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  5 DB1=011, DB2=050 : 140,25 MHz = ntv
	MOVLW   D'011'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'050'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000010'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  6 DB1=011, DB2=162 : 147,25 MHz = Kabel1
	MOVLW   D'011'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'162'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  7 DB1=012, DB2=018 : 154,25 MHz = CNN
	MOVLW   D'012'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'018'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  8 DB1=012, DB2=130 : 161,25 MHz = Pro7
	MOVLW   D'012'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'130'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	;  9 DB1=012, DB2=242 : 168,25 MHz = BR3   
	MOVLW   D'012'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'242'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 10 DB1=013, DB2=098 : 175,25 MHz = ARD
	MOVLW   D'013'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 11 DB1=013, DB2=210 : 182,25 MHz = ZDF
	MOVLW   D'013'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'210'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 12 DB1=014, DB2=066 : 189,25 MHz = SW3
	MOVLW   D'014'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'066'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 13 DB1=014, DB2=178 : 196,25 MHz = RTL
	MOVLW   D'014'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'178'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 14 DB1=015, DB2=034 : 203,25 MHz = SAT1
	MOVLW   D'015'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'034'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 15 DB1=015, DB2=146 : 210,25 MHz = arte/KiKa
	MOVLW   D'015'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'146'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 16 DB1=016, DB2=002 : 217,25 MHz = WDR
	MOVLW   D'016'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'002'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 17 DB1=016, DB2=114 : 224,25 MHz = DRS
	MOVLW   D'016'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'114'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 18 DB1=016, DB2=226 : 231,25 MHz = DSF
	MOVLW   D'016'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'226'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 19 DB1=017, DB2=082 : 238,25 MHz = 3sat
	MOVLW   D'017'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'082'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 20 DB1=017, DB2=194 : 245,25 MHz = Eurosport
	MOVLW   D'017'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'194'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 21 DB1=018, DB2=050 : 252,25 MHz = RTL2
	MOVLW   D'018'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'050'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 22 DB1=018, DB2=162 : 259,25 MHz = VIVA
	MOVLW   D'018'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'162'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 23 DB1=019, DB2=018 : 266,25 MHz = TV5
	MOVLW   D'019'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'018'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 24 DB1=019, DB2=130 : 273,25 MHz = MTV 
	MOVLW   D'019'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'130'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 25 DB1=019, DB2=242 : 280,25 MHz = VOX
	MOVLW   D'019'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'242'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 26 DB1=020, DB2=098 : 287,25 MHz = Citydirekt/HOT/RTV
	MOVLW   D'020'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 27 DB1=020, DB2=210 : 294,25 MHz = BTV 
	MOVLW   D'020'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'210'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 28 DB1=021, DB2=098 : 303,25 MHz = Viva2
	MOVLW   D'021'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 29 DB1=021, DB2=226 : 311,25 MHz = Euronews
	MOVLW   D'021'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'226'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 30 DB1=022, DB2=098 : 319,25 MHz = Phoenix
	MOVLW   D'022'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 31 DB1=022, DB2=226 : 327,25 MHz = NBC
	MOVLW   D'022'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'226'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 32 DB1=023, DB2=098 : 335,25 MHz = MDR  
	MOVLW   D'023'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck
	; 33 DB1=028, DB2=098 : 415,25 MHz = QVC
	MOVLW   D'028'          ; DB1 nach W
	MOVWF   TMPA            ; DB1 nach TMPA
	MOVLW   D'098'          ; DB2 nach W
	MOVWF   TMPB            ; DB2 nach TMPB
	MOVLW   B'00000100'     ; Bandselektion nach W
	GOTO    SENDCR                  ; zurueck

;*************************************************************************
	END                     ; das wars dann
